const MXNOTE_RES_PREFIX = "mxn://r?u=";

var Note = {};
Note.images = [];
Note.title = document.getElementById('title_input_id');
Note.url = document.getElementById("url_input_id");
Note.titleContainer = document.getElementById("title_container_id");
Note.titleContainer.style.display = "none;"
Note.urlContainer = document.getElementById("url_container_id");
Note.urlContainer.style.display = "none";
Note.titleP = document.getElementById('titleP');
Note.topDiv = document.getElementById("top_div_id");
// Note.topDiv.style.display = "none";
Note.titleP.style.display = "none";
document.getElementById("lock_img_id").style.display = "none";
Note.shouldShowLockIcon = false;

RE.editor.addEventListener("focus", function (e) {
	console.log('editor: focus:');
	if (RE.editor.innerHTML === RE.contentPHValue) {
		RE.editor.innerHTML = "";
		RE.editor.classList.remove("placeholder_text");
		RE.editor.classList.add("normal_text");
	}
	
	if (window.NoteJs !== undefined) {
		window.NoteJs.onFocus('editor');
	}
})
function handleEditorChange(){
    console.log("Text changed (handled once):", RE.editor.innerHTML);
    RE.editor.removeEventListener("input", handleEditorChange);
    window.NoteJs.onNoteChanged();
}
RE.editor.addEventListener("input", handleEditorChange);

RE.editor.addEventListener("blur", function (e) {
	if (RE.editor.innerHTML === "") {
		RE.editor.innerHTML = RE.contentPHValue;
		RE.editor.classList.remove("normal_text");
		RE.editor.classList.add("placeholder_text");
	}
});

Note.title.addEventListener("focus", function (e) {
	console.log('title: focus:');
	
	if (Note.title.value === RE.titlePHValue) {
		Note.title.value = "";
		Note.title.classList.remove("placeholder_text");
		Note.title.classList.add("normal_text");
	}
	
	if (window.NoteJs !== undefined) {
		window.NoteJs.onFocus('title');
	}
});

Note.title.addEventListener("blur", function (e) {
	console.log('title: blur:');
	
	if (Note.title.value == "") {
		Note.title.value = RE.titlePHValue;
		Note.title.classList.remove("normal_text");
		Note.title.classList.add("placeholder_text");
	}
});

Note.url.addEventListener("focus", function (e) {
	console.log('url: focus:');
	
	if (Note.url.value == RE.urlPHValue) {
		Note.url.value = "";
		Note.url.classList.remove("placeholder_text");
		Note.url.classList.add("normal_text");
	}
	
	if (window.NoteJs !== undefined) {
		window.NoteJs.onFocus('url');
	}
});

Note.url.addEventListener("blur", function (e) {
	console.log('url: blur:');
	
	if (Note.url.value == "") {
		Note.url.value = RE.urlPHValue;
		Note.url.classList.remove("normal_text");
		Note.url.classList.add("placeholder_text");
	}
	
});

Note.setTitle = function (titles) {
	var title = decodeURIComponent(titles.replace(/\+/g, '%20'));
	console.log("setTitle:" + title);
	Note.title.value = title;
	Note.titleP.innerText = title;
	Note.titleContainer.style.display = "block";
	Note.title.classList.remove("placeholder_text");
	Note.title.classList.add("normal_text");
}

Note.setTitlePlaceholder = function (title) {
	Note.title.value = title;
	RE.titlePHValue = title;
	Note.titleContainer.style.display = "block";
	Note.title.classList.remove("normal_text");
	Note.title.classList.add("placeholder_text");
}

Note.hideUrl = function() {
	Note.urlContainer.style.display = "none";
}

Note.setUrl = function (urls) {
	var url = decodeURIComponent(urls.replace(/\+/g, '%20'));
	Note.url.value = url;
	Note.urlContainer.style.display = "block";
	Note.url.classList.remove("placeholder_text");
	Note.url.classList.add("normal_text");
}

Note.setUrlPlaceholder = function (url) {
	Note.url.value = url;
	RE.urlPHValue = url;
	Note.url.classList.remove("normal_text");
	Note.url.classList.add("placeholder_text");
}

async function getUploadUrl(filename, userId) {
	const res = await fetch(
			"https://syncapi.maxthon.com/userfile/getUploadUrl?key=_passverify",
			{
				method: "POST",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify({
					type: "noteres",
					filename,
					uid: userId,
				}),
			}
	);
	
	return await res.json();
}

Note.getImageUploadUrls = async function () {
	// Calling this JS API function will return an array of image with their corresponding URLs:
	// i.e. serverUrl, localPath, and uploadUrl.
	window.NoteJs.getNoteImageUrls(Note.images);
}

Note.getNoteInfo = async function (uid) {
	var info = {};
	info["title"] = Note.title.value;
	info["url"] = Note.url.value;
	
	//const testUid = 208;  // TODO: Remember to remove this after testing
	
	if (uid !== "anonymous") {
		// We replace the img.src value so that it will be in sync with the server URL.
		var noteImages = document.querySelectorAll("img");
		
		for (const img of noteImages) {
			console.log("Before replacing the image's src attribute: " + img.src);
			const imgUrlParts = img.src.split("/");
			// First, we check if the image source begins with the mxn:// scheme.
			// If it has the mxn:// scheme, then we don't have to perform the upload.
			const fname = imgUrlParts[imgUrlParts.length - 1]
			const ext = fname.toLowerCase().split('.').pop()
			const isImg = ['png','jpg','jpeg','svg','webp','gif'].includes(ext)
			if (!img.src.startsWith("mxn://")&&isImg) {
				// We just want the final portion which is the filename.
				const ret = await getUploadUrl(fname, uid);
				const {url, uploadUrl, token, filename} = ret;
				console.log(ret);
				Note.images.push({
					local: img.src,
					server: url,
					upload: uploadUrl,
					token: token,
					filename: filename
				});
				img.src = MXNOTE_RES_PREFIX + url;
			}
			console.log("After replacing the image's src attribute: " + img.src);
		}
		info["images"] = Note.images;
	}
	
	info["content"] = RE.getHtml();
	info["summary"] = RE.getText().substring(0, 100);
	info["content_bak"] = RE.contents;
	var jsonString = JSON.stringify(info);
	console.log("getNoteInfo:  " + jsonString);
	window.NoteJs.getNoteInfo(jsonString);
}

// Note.getNoteInfo = function(temp){
//   var info = {};
//   info["title"] = Note.title.value;
//   info["url"] = Note.url.value;
//   info["temp"] = temp;
//   info["content"] = RE.getHtml();
//   info["content_bak"] = RE.contents;
//   var jsonString = JSON.stringify(info);
//   console.log("getNoteInfo:  "+jsonString);
//   window.NoteJs.getNoteInfo(jsonString);
// }

Note.selectNote = function () {
	console.log("onNoteSelected");
	if (window.NoteJs !== undefined) {
		window.NoteJs.onNoteSelected();
	}
}

Note.getWalkNoteInfo = function (temp) {
	var info = {};
	info["title"] = Note.title.value;
	info["url"] = Note.url.value;
	info["temp"] = temp;
	info["content"] = RE.getHtml();
	var jsonString = JSON.stringify(info);
	console.log("getNoteInfo:  " + jsonString);
	return jsonString;
}

Note.showLockIcon = function () {
	Note.shouldShowLockIcon = true;
}

Note.hideLockIcon = function () {
	Note.shouldShowLockIcon = false;
	document.getElementById("lock_img_id").style.display = "none";
}

Note.showLoading = function () {
	document.getElementById("note_loading_div_id").style.display = "";
}
