local maxFaceCount = 10
local currentIndex = -1
local faceDetIDArray = {}
local faceDetNum = 0
local tempIntensitys = {}
local basicIntensitys = {}


local faceuFeaturePath = "v5/"
local keyName = "original_face"

-- keep EyeType in structure is for coordination with facepoint structure
local organName =
{
    "DISTORTION_V3_XT_FAR_EYE",
    "DISTORTION_V3_XT_ZOOM_EYE",
    "DISTORTION_V3_XT_ROTATE_EYE",
    "DISTORTION_V3_XT_MOVE_EYE",
    "DISTORTION_V3_XT_ZOOM_NOSE",
    "DISTORTION_V3_XT_MOVE_NOSE",
    "DISTORTION_V3_XT_MOVE_MOUTH",
    "DISTORTION_V3_XT_ZOOM_MOUTH",
    "DISTORTION_V3_XT_MOVE_CHIN", --下巴长短
    "DISTORTION_V3_XT_ZOOM_FOREHEAD",
    "DISTORTION_V3_XT_ZOOM_FACE",
    "DISTORTION_V3_XT_CUT_FACE", --宽脸
    "DISTORTION_V3_XT_SMALL_FACE",
    "DISTORTION_V3_XT_ZOOM_JAW_BONE", --下颌
    "DISTORTION_V3_XT_ZOOM_CHEEK_BONE", --颧骨
    "DISTORTION_V3_XT_DRAG_LIPS",
    "DISTORTION_V3_XT_CORNER_EYE",
    "DISTORTION_V3_XT_LIP_ENHANCE",
    "DISTORTION_V3_XT_POINTY_CHIN",
    "DISTORTION_V3_XT_TEMPLE",
    " ", -- eye type
    "DISTORTION_V3_XT_VFACE" --瘦脸
}

local V5organParam = 
{
    0.102,
    -0.039,
    0.049,
    -0,
    -0.032,
    0.032,
    -0.098,
    -0.07,
    -0,
    -0.2,
    -0.2,
    -0.112,
    -0.042,
    0.042,
    -0.053,
    -0,
    -0,
    -0,
    -0.018,
    -0,
    " ", --2, eye type
    -0.07
}


-- 22 items in organParam, [0,20] [22] 是小项，[21]是眼睛类型
-- 自然脸
local organParam =
{
 0.08,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
 -0.2,
    0,
-0.01,
    0,
    0,
    0,
    0,
    0,
    0,
 -0.2,
    2,
    0
}

-- 对齐轻颜
-- small item param range
local organParamRange =
{
    { -0.18, 0.18}, -- far eye
    {    0,     0}, -- zoom eye
    {    0,     0}, -- rotate eye
    {  0.2,  -0.2}, -- move eye
    {    0,     0}, -- zoom nose
    {    0,     0}, -- move nose
    { 0.22, -0.22}, -- move mouth
    {  0.2,  -0.2}, -- zoom mouth
    { 0.12, -0.18}, -- move chin
    {  0.2,  -0.2}, -- zoom forehead
    {    0,     0}, -- zoom face
    {    0.2,  -0.2}, -- cut face
    {    0,   -0.07}, -- small face
    {    0.2,  -0.2}, -- jawbone
    {    0.2,  -0.2}, -- cheek bone
    {    0,     0}, -- mouth corner
    { 0.15, -0.15}, -- corner eye
    {    0,     0}, -- lip enhance
    {  0.2,  -0.2}, -- pointy chin
    {    0,     0}, -- temple
    {    0,     0}, -- eye type
    {    0,  -1.4}, -- vface
}

local organParamPercentageInit =
{
      0.5, -- far eye
        0, -- zoom eye
        0, -- rotate eye
      0.5, -- move eye
        0, -- zoom nose
      0.5, -- move nose
      0.5, -- move mouth
      0.5, -- zoom mouth
0.4117647, -- move chin
      0.5, -- zoom forehead
        0, -- zoom face
        0, -- cut face
        0, -- small face
        0, -- jawbone
        0, -- cheek bone
        0, -- mouth corner
        0, -- corner eye
        0, -- lip enhance
      0.5, -- pointy chin
        0, -- temple
        0, -- eye type
        0, -- vface
}

-- param range in engine
local organMaxInEigine =
{
        3, -- far eye, set default param max value to 3
      0.2, -- zoom eye
        3, -- rotate eye
      0.2, -- move eye
      0.2, -- zoom nose
     0.28, -- move nose
     0.36, -- move mouth
      0.2, -- zoom mouth
      0.2, -- move chin
      0.2, -- zoom forehead
        3, -- zoom face
      0.2, -- cut face
      0.2, -- small face
      0.2,-- jawbone
      0.2, -- cheek bone
      0.2, -- mouse corner
      0.2, -- corner eye
        3, --  lip enhance
      0.2, -- pointy chin
        3, -- temple
        3, -- eye type
        2, -- vface
}

local organParamSpecific = {}
local organParamCurrent = {}

local faceuInit = false

-- 确保获取的比例值是在[0,1]区间内
local function validatePercentage(percentage)
    if percentage < 0 then
        percentage = 0
    elseif percentage > 1 then
        percentage = 1
    end
    return percentage
end

-- 确保将要设置到引擎里面的参数在引擎允许值的范围内
local function validateParam(value, index)
    if value > organMaxInEigine[index] then
        value = organMaxInEigine[index]
    elseif value < -organMaxInEigine[index] then
        value = -organMaxInEigine[index]
    end
    return value
end

-- 获取每个小项在特定比例下调整后的具体参数
-- 注意正负非对称的情况，要特殊处理，比如 Internal_Deform_Chin，因为要确保滑竿0.5时没有形变效果
local function getSmallItemValueBy(percentage, index)
    if index == 9 or index == 12 or index == 14 or index == 15 then -- Internal_Deform_Chin
        if percentage < 0.5 then
            percentage = 1 - percentage * 2 -- [0, 0.5) -> [1, 0)
            return percentage * organParamRange[index][1]
        elseif percentage > 0.5 then
            percentage = percentage * 2 - 1 -- (0.5, 1] -> (0, 1]
            return percentage * organParamRange[index][2]
        else
            return 0
        end
    end
    percentage = validatePercentage(percentage)
    return organParamRange[index][1] + percentage * (organParamRange[index][2] - organParamRange[index][1])
end

-- 根据下标和比例设置小项值
local function setIntensityForSmallItem(feature, percentage, index)
    --organParamSpecific[index] = getSmallItemValueBy(percentage, index) 
    --local value = validateParam(organParamSpecific[index] + organParamCurrent[index], index)
    local value = V5organParam[index] * percentage 
    feature:setIntensity(organName[index], value)
end

-- 获取基础脸型调整的具体参数
local function getBasicFaceValueBy(percentage, index)
    -- percentage = validatePercentage(percentage)
    if percentage < 0.5 then
        percentage = 1 - percentage * 2 -- [0, 0.5) -> [1, 0)
        percentage = -1.0 * validatePercentage(percentage)
    elseif percentage > 0.5 then
        percentage = percentage * 2 - 1 -- (0.5, 1] -> (0, 1]
        percentage = validatePercentage(percentage)
    else
        return 0
    end
    return percentage * organParam[index]
end

-- 整体 调整基础脸型时设置每个小项的参数
local function setIntensityForBasicFace(feature, percentage, index)
    -- organParamCurrent[index] = getBasicFaceValueBy(percentage, index)
    --local value = validateParam(organParamSpecific[index] + organParamCurrent[index], index)
    local value = V5organParam[index] * percentage 
    feature:setIntensity(organName[index], value)
end

-- 用滑杆的初始值来初始化小项的值
local function initAllSmallItem(feature)
    for i = 1,20 do
        setIntensityForSmallItem(feature, organParamPercentageInit[i], i);
    end
    setIntensityForSmallItem(feature, organParamPercentageInit[22], 22);
end

-- 初始化系统参数并使用滑杆初始值来初始化小项的值
local function initSystem(this)
    faceuInit = true
    local organParamCount = #organParam
    for i = 1, organParamCount do
        table.insert(organParamSpecific, i, 0)
        table.insert(organParamCurrent, i, 0)
        -- print("organParamCurrent", i, organParamCurrent[i])
    end

    local feature = this:getFeature(faceuFeaturePath)
    if not feature then
        print("dsFaceu feature nil")
        return
    end
    -- initAllSmallItem(feature)
end

local function resetIntensity(feature, id, index)
    for i = 1, 22 do
        organParamSpecific[i] = 0
        organParamCurrent[i] = 0
    end
    feature:setIntensity("DISTORTION_V3_FACE_ID", id)
    local percentage = basicIntensitys[index]
    if percentage~=nil then 
        for i = 1, 20 do
            setIntensityForBasicFace(feature, percentage, i);
        end
        setIntensityForBasicFace(feature, percentage, 22);
    end
    local IntensityItem = tempIntensitys[index]
    if IntensityItem~=nil then 
        for i, intensity in pairs(IntensityItem) do
            setIntensityForSmallItem(feature, intensity, i)
        end
    end
end

local function updateFaceId(this)
    local Bundle = this:getEffectManager():getBundleInfo()
    if not Bundle then
        print("dsFaceu Bundle nil")
        return
    end
    faceDetIDArray = {}
    for i = 0, maxFaceCount do
        local pts = Bundle:GetFloatArray("cv248points_"..i)
        if pts~=nil then
            local id = Bundle:GetInt("cv248id_"..i)
            faceDetIDArray[i] = id
        else
            faceDetNum = i
            return
        end
    end
end

local function updataIDIntensity(this, oldFaceDetNum, oldIDArray, newFaceDetNum, newIDArray)
    local feature = this:getFeature(faceuFeaturePath)
    if not feature then
        print("dsFaceu feature nil")
        return
    end
    -- if oldFaceDetNum ~= newFaceDetNum then
    --     tempIntensitys = {}
    --     return
    -- end
    for index, IntensityItem in pairs(tempIntensitys) do
        print("dsFaceu index = "..index)
        if(index >= 0 and index < newFaceDetNum) then
            local ID = newIDArray[index]
            print("dsFaceu new id = "..ID)
            resetIntensity(feature, ID, index)
        end
    end
    local currentID = newIDArray[currentIndex]
    if(currentID ~= nil) then
        feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        resetIntensity(feature, currentID, currentIndex)
    end
end

local function setTempIntensity(tag, percentage)
    if (tag == keyName) then     -- 瘦脸
        basicIntensitys[currentIndex] = percentage
        return
    end
end

EventHandles =
{
    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        -- 和composer配合使用时，有可能handleComposerUpdateNodeEvent调用在handleEffectEvent之前，
        -- 所以这里要考虑初始化
        if not faceuInit then
            print("dsFaceu handleComposerUpdateNodeEvent init")
            initSystem(this)
        end

        print("dsFaceu handleComposerUpdateNodeEvent path = ", path, "\n")
        print("dsFaceu handleComposerUpdateNodeEvent tag = ", tag, "\n")
        print("dsFaceu handleComposerUpdateNodeEvent value = ", percentage, "\n")
        local feature = this:getFeature(faceuFeaturePath)
        if not feature then
            print("dsFaceu feature nil")
            return
        end

        if (tag == "currentIndex") then
            updateFaceId(this)
            currentIndex = math.floor(percentage)
            print("dsFaceu currentIndex"..currentIndex)
            local currentID = faceDetIDArray[currentIndex]
            if(currentID == nil) then
                print("dsFaceu currentID nil")
                return
            end
            resetIntensity(feature, currentID, currentIndex)
            feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        end
        if (tag == "currentID") then
            updateFaceId(this)
            local currentID = math.floor(percentage)
            currentIndex = -1
            for index, ID in pairs(faceDetIDArray) do
                if ID == currentID then
                    currentIndex = index
                end
            end
            if currentIndex < 0  then
                return
            end
            resetIntensity(feature, currentID, currentIndex)
            feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        end
        if(tempIntensitys[currentIndex] == nil) then
            tempIntensitys[currentIndex] = {}
        end
        if currentIndex >= 0 then
            setTempIntensity(tag, percentage)
            local currentID = faceDetIDArray[currentIndex]
            if(currentID == nil) then
                print("dsFaceu currentID nil")
                return
            end
            feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        end
        
        local featurev6 = this:getFeature("v6")

        if (tag == keyName) then     -- 瘦脸
            print("faceDeformation 瘦脸")
            featurev6:setIntensity("DISTORTION_V6_ALL", percentage)
            basicIntensitys[currentIndex] = percentage
            for i = 1, 20 do
                setIntensityForBasicFace(feature, percentage, i);
            end
            setIntensityForBasicFace(feature, percentage, 22);
        end

        --v6
        local effectInterface = this:getEffectManager()
        local effectManager = EffectSdk.castEffectManager(effectInterface)

        if percentage == 0.0 then
            featurev6:setFeatureStatus(EffectSdk.BEF_FEATURE_STATUS_ENABLED, false)
            if effectInterface and effectManager then
                effectManager:setFeatureAlgorithmPairs(featurev6:getAbsPath(), EffectSdk.BefRequirement())
            end
        else
            featurev6:setFeatureStatus(EffectSdk.BEF_FEATURE_STATUS_ENABLED, true)
            if effectInterface and effectManager then
                effectManager:setFeatureAlgorithmPairs(featurev6:getAbsPath(), featurev6:getRequirement())
            end
        end

        return true
    end,
    handleEffectEvent = function(this, eventCode)
        if not faceuInit then
            print("dsFaceu handleEffectEvent init")
            initSystem(this)
        end
        return true
    end,
    handleFaceInfoEvent = function(this, faceInfo)
        print("dsFaceu handleFaceInfoEvent")
        local newfaceDetNum = faceInfo:getFaceCount()
        local newfaceDetIDArray = {}
        for i = 0, newfaceDetNum - 1 do
            newfaceDetIDArray[i] = faceInfo:getFaceID(i)
            print("dsFaceu handleFaceInfoEvent getFaceID: ", faceInfo:getFaceID(i))
        end
        print("dsFaceu handleFaceInfoEvent newfaceDetNum: ", newfaceDetNum)
        updataIDIntensity(this, faceDetNum, faceDetIDArray, newfaceDetNum, newfaceDetIDArray)
        faceDetNum = newfaceDetNum
        faceDetIDArray = newfaceDetIDArray
    end,
}
