precision highp float;
varying vec2 v_texcoord;
varying vec4 v_opacity;
uniform float hardness;
uniform float strokeSize;

void main()
{
    float dist = distance(v_texcoord, vec2(0.5));
    float shapeMask = 1.0 - smoothstep(0.5 * hardness - max(1.0, min(3.0, 0.1 * strokeSize)) / strokeSize, 0.5, dist);
    gl_FragColor = shapeMask * v_opacity;
}
