precision highp float;
varying vec2 v_texcoord;
uniform sampler2D strokeTexture;
uniform sampler2D layerTexture;
uniform sampler2D originTexture;
uniform vec2 resolution;
uniform float pixelSize;
uniform float colorA;
uniform float useFlip;

const vec2 pixelRatio = vec2(1.0, 1.0);

void main() {
    vec4 strokeColor = texture2D(strokeTexture, v_texcoord);
    vec4 layerColor = texture2D(layerTexture, v_texcoord);

    float maskAlpha = strokeColor.x * colorA;
    if (maskAlpha > 0.0)
    {
        vec2 flipPos = vec2(v_texcoord.x, mix(v_texcoord.y, 1.0 - v_texcoord.y, useFlip));
        vec2 sampleGrid = floor(pixelRatio * pixelSize * max(resolution.x, 0.5 * resolution.y)) / resolution;
        vec2 samplePos = flipPos - mod(flipPos, sampleGrid) + 0.5 * sampleGrid;
        vec4 mosaicColor = texture2D(originTexture, samplePos);
        float originAlpha = texture2D(originTexture, flipPos).a;
        gl_FragColor = mix(layerColor, mosaicColor, maskAlpha) * originAlpha;
    }
    else
    {
        gl_FragColor = layerColor;
    }
}
