precision highp float;
varying vec2 v_texcoord;
uniform sampler2D strokeTexture;
uniform sampler2D layerTexture;
uniform float colorA;

void main()
{
    vec4 simpleMask = texture2D(strokeTexture, v_texcoord);
    vec4 layer = texture2D(layerTexture, v_texcoord);
    if (simpleMask.x > 0.1)
    {
        gl_FragColor = layer * (1.0 - simpleMask.x * colorA);
    }
    else
    {
        gl_FragColor = layer;
    }
}
