#version 300 es
precision highp float;

in vec2 v_TextureCoordinates;

uniform sampler2D u_inputTexture; // its alpha is the origMask
uniform sampler2D u_targetTexture;
uniform sampler2D u_inputMask;
uniform vec4  u_cropRegion;
uniform float u_level;
uniform bool u_useOrigMask;

layout(location=0) out vec4 fragColor;

void main()
{
    vec4 srcColor = texture(u_inputTexture, v_TextureCoordinates);
    if(v_TextureCoordinates.x >= u_cropRegion.x &&
       v_TextureCoordinates.x <= u_cropRegion.x + u_cropRegion.z &&
       v_TextureCoordinates.y >= u_cropRegion.y &&
       v_TextureCoordinates.y <= u_cropRegion.y + u_cropRegion.w)
    {
        vec2 uvCrop = (v_TextureCoordinates - u_cropRegion.xy) / u_cropRegion.zw;
        float alpha = textureLod(u_inputMask, uvCrop, u_level).a;
        if (u_useOrigMask)
        {
            alpha *= srcColor.a;
        }
        vec3 tarColor = textureLod(u_targetTexture, uvCrop, u_level).rgb;
        fragColor = vec4(mix(srcColor.rgb, tarColor, alpha), srcColor.a);
    }
    else
    {
        fragColor = srcColor;
    }
}
