local exports = exports or {}
local SeekModeScript = SeekModeScript or {}
SeekModeScript.__index = SeekModeScript
function SeekModeScript.new(construct, ...)
    local self = setmetatable({}, SeekModeScript)
    if construct and SeekModeScript.constructor then
        SeekModeScript.constructor(self, ...)
    end
    self.hsl_param = {
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0),
        Amaz.Vector3f(0.0, 0.0, 0.0)
    }
    self.hsl_param_limit = {
        {h_min = -15, h_max = 15, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -5, h_max = 5, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -20, h_max = 20, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -30, h_max = 30, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -20, h_max = 20, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -20, h_max = 20, s_min = -100, s_max = 50, b_min = -30, b_max = 30},
        {h_min = -0.2, h_max = 0.3, s_min = -30, s_max = 30, b_min = -30, b_max = 30}
    }
    self.currrent_mode = 1
    return self
end

function SeekModeScript:constructor()
end

function SeekModeScript:onUpdate(comp, detalTime)
    self:seekToTime(comp, detalTime)
end

function SeekModeScript:start(comp)
    self.material = comp.entity:getComponent("MeshRenderer").sharedMaterials:get(0)
end

function SeekModeScript:seekToTime(comp, time)
    if self.first == nil then
        self.first = true
        self:start(comp)
    end
end

function SeekModeScript:onEvent(sys, event)
    if ("Color_Mode" == event.args:get(0)) then
        self.currrent_mode = math.floor(event.args:get(2))
        if self.currrent_mode < 1 or self.currrent_mode > 7 then
            self.currrent_mode = 1
        end
    end
    -- "Hue"
    if ("Hue" == event.args:get(0)) then
        local hue = (event.args:get(2) * 2.0) - 1.0
        if hue < 0.0 then
            hue = -1 * hue * self.hsl_param_limit[self.currrent_mode].h_min
        else
            hue = hue * self.hsl_param_limit[self.currrent_mode].h_max
        end
        self.hsl_param[self.currrent_mode].x = hue
    end
    -- "Saturation"
    if ("Saturation" == event.args:get(0)) then
        local saturation = (event.args:get(2) * 2.0) - 1.0
        if saturation < 0.0 then
            saturation = -1 * saturation * self.hsl_param_limit[self.currrent_mode].s_min
        else
            saturation = saturation * self.hsl_param_limit[self.currrent_mode].s_max
        end
        self.hsl_param[self.currrent_mode].y = saturation
    end
    -- "Brightness"
    if ("Brightness" == event.args:get(0)) then
        local brightness = (event.args:get(2) * 2.0) - 1.0
        if brightness < 0.0 then
            brightness = -1 * brightness * self.hsl_param_limit[self.currrent_mode].b_min
        else
            brightness = brightness * self.hsl_param_limit[self.currrent_mode].b_max
        end
        self.hsl_param[self.currrent_mode].z = brightness
    end
    for i = 1, 7 do
        self.material:setVec3("hsl_param_" .. (i - 1), self.hsl_param[i])
    end
end

exports.SeekModeScript = SeekModeScript
return exports
