local initFlag = true
local featurePath = "combination-all"
local ge = nil

local maxTextureUnits = 0

local grain_max_width = 1200
local grain_max_height = 1200
local grain_max_width_inv = 0.00195312 -- 1. / 512
local grain_max_height_inv = 0.00195312

local ratio = 0.3
local height = 0.
local width = 0.
local count = 0
local ori_max_count = 10
local max_count = 0
local random_x1 = 0.
local random_y1 = 0.

local function setParam(this, generalEffect, filter, tag, percentage)
    local intensity = percentage
    if tag == "brightness" then
        generalEffect:setUniformFloat(filter, 1, "intensityBrightness",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "contrast" then
        generalEffect:setUniformFloat(filter, 1, "intensityContrast",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "shadow" then
        generalEffect:setUniformFloat(filter, 1, "intensityShadow", 
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "highlight" then
        generalEffect:setUniformFloat(filter, 1, "intensityHighlight",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "temperature" then
        local intensity = percentage
        generalEffect:setUniformFloat(filter, 1, "intensityTemperature",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "tone" then
        local intensity = percentage
        generalEffect:setUniformFloat(filter, 1, "intensityTone",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "saturation" then
        local intensity = percentage
        generalEffect:setUniformFloat(filter, 1, "intensitySaturation",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "lightSensation" then
        local intensity = percentage
        generalEffect:setUniformFloat(filter, 1, "intensityLightSensation",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "fade" then
        local intensity = percentage
        generalEffect:setUniformFloat(filter, 1, "intensityFade", intensity)
        return true
    elseif tag == "structure" then
        generalEffect:setUniformFloat(filter, 1, "intensityStructure",
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "sharp" then
        generalEffect:setUniformFloat(filter, 1, "intensitySharp", intensity)
        return true
    elseif tag == "oilTexture" then
        generalEffect:setUniformFloat(filter, 1, "intensityTexture", intensity)
        return true
    elseif tag == "exposure" then
        generalEffect:setUniformFloat(filter, 1, "intensityExposure", 
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "vibrance" then
        generalEffect:setUniformFloat(filter, 1, "intensityVibrance", 
                                      intensity * 2.0 - 1.0)
        return true
    elseif tag == "grain" then
        width = this:getEffectManager():getInputWidth()
        height = this:getEffectManager():getInputHeight()
        generalEffect:setUniformFloat(filter, 1, "intensityGrain", intensity)
        max_count = 5.0
        local height_inv = 0
        local width_inv = 0
        if height ~= 0 then height_inv = 1. / height end
        if width ~= 0 then width_inv = 1. / width end

        local grain_width
        local grain_height
        local u_max
        local v_max
        if height >= width then
            grain_width = grain_max_width
            grain_height = grain_max_width * width_inv * height
        else
            grain_width = grain_max_height * height_inv * width
            grain_height = grain_max_height
        end

        u_max = grain_width * grain_max_width_inv
        v_max = grain_height * grain_max_height_inv
        generalEffect:setUniformFloat(filter, 1, "u_max", u_max)
        generalEffect:setUniformFloat(filter, 1, "v_max", v_max)

        if count >= max_count then
            count = 0
        else
            count = count + 1
        end

        if count == 0 then
            random_x1 = math.random()
            random_y1 = math.random()
        end

        if max_count == 0 then
            random_x1 = 0
            random_y1 = 0
        end
        generalEffect:setUniformFloat(filter, 1, "random_x1", random_x1)
        generalEffect:setUniformFloat(filter, 1, "random_y1", random_y1)
        return true
    end
end

EventHandles = {
    handleEffectEvent = function(this, eventCode)
        if initFlag then
            local feature = this:getFeature(featurePath)
            ge = EffectSdk.castGeneralEffectFeature(feature)
            if ge == nil then
                print("ge feature is nil!")
                return
            end

            print("zglog GESticker_Manual enable")
            ge:setFeatureStatus(4, true)

            initFlag = false

        end
        return true
    end,

    handleComposerUpdateNodeEvent = function(this, path, tag, percentage)
        if ge == nil then
            print("ge feature is nil!")
            return
        end
        print("zglog ge " .. tag .. "  " .. percentage)
        if tag == "sharp" or tag == "structure" or tag == "oilTexture" or
                tag == "grain" then
            setParam(this, ge, "final", tag, percentage)
        else
            setParam(this, ge, "shader", tag, percentage)
        end

    end
}
