precision highp float;
varying vec2 v_texcoord;
uniform sampler2D strokeTexture;
uniform sampler2D layerTexture;
uniform vec3 colorRGB;
uniform float colorA;

void main()
{
    vec4 layer = texture2D(layerTexture, v_texcoord);
    vec4 simpleMask = texture2D(strokeTexture, v_texcoord);
    if (simpleMask.r > 0.0)
    {
        gl_FragColor = vec4(colorRGB, max(colorA * simpleMask.r, layer.a));
        gl_FragColor.rgb *= gl_FragColor.a;
    }
    else
    {
        gl_FragColor = layer;
    }
}
