"use strict";
var CCJsScriptClass = class {
    constructor() {
        this.isFrameSampling = false;
        this.timeline = null;
        this.filterVideoClips = [];
        this.unUsedClips = [];
    }

    onInit(clip) {
        CCLOGI("CCJsScript onInit.");
    }

    onMediaTimelineBuild(clip, timeline) {
        this.timeline = timeline;
        this.isFrameSampling = clip.getParamValue("is_frame_sampling");
    }

    onPreUpdate(clip, timeStamp) {
        if (this.isFrameSampling) {
            let fullTypes = [
                ETEClipType.TEClipType_VideoAudio,
                ETEClipType.TEClipType_Video,
                ETEClipType.TEClipType_Audio,
                ETEClipType.TEClipType_Image,
                ETEClipType.TEClipType_Camera,
                ETEClipType.TEClipType_Color,
                ETEClipType.TEClipType_Mic,
                ETEClipType.TEClipType_RgbaRaw,
                ETEClipType.TEClipType_Effect,
                ETEClipType.TEClipType_Sequence,
                ETEClipType.TEClipType_CameraMic,
                ETEClipType.TEClipType_TexDesc,
                ETEClipType.TEClipType_AVEffectVideo,
                ETEClipType.TEClipType_AVEffectImage,
                ETEClipType.TEClipType_Algorithm,
                ETEClipType.TEClipType_MultiView,
            ];
            let allClips = this.timeline.getClipsByType(fullTypes);
            this.unUsedClips = allClips.filter(iClip => {
                return iClip.getClipLayer() > clip.getClipLayer();
            });
            this.unUsedClips.forEach((uClip, _) => {
                uClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, false);
            });
        }
        
        let types = [
            ETEClipType.TEClipType_Video,
            ETEClipType.TEClipType_VideoAudio,
            ETEClipType.TEClipType_Image,
            ETEClipType.TEClipType_Sequence
        ];
        let videoClips = this.timeline.getClipsByType(types);
        this.filterVideoClips = videoClips.filter(iClip => {
            return iClip.getClipLayer() == clip.getClipLayer();
        });
        this.filterVideoClips.forEach((fviClip, _) => {
            let effectClips = fviClip.getEffectClipsListByType(ETEFilterType.TEFilterType_All);
            let smartLightClips = fviClip.getEffectClipsListByType(ETEFilterType.TEFilterType_Smart_Lighting);
            if (this.isFrameSampling) {
                if (smartLightClips) {
                    smartLightClips.forEach((eClip, _) => {
                        eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, false);
                    });
                }
                // check if is fliter effect clip or is adjustment effect clip
                if (effectClips) {
                    effectClips.forEach((eClip, _) => {
                        if (eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Video_Filter || eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Color_Adjust) {
                            eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, false);
                        }
                    });
                }
            } else {
                if (effectClips) {
                    effectClips.forEach((eClip, _) => {
                        eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, false);
                    });
                }
                if (smartLightClips) {
                    smartLightClips.forEach((eClip, _) => {
                        eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
                    });
                }
                // check if is fliter effect clip or is adjustment effect clip
                if (effectClips) {
                    effectClips.forEach((eClip, _) => {
                        if (eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Video_Filter || eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Color_Adjust) {
                            eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
                        }
                    });
                }
            }
        });
    }

    // onUpdate(clip, timeStamp) {
    //     CCLOGI("CCJsScript onUpdate timeStamp: " + timeStamp);
    // }

    onPostUpdate(clip, timeStamp) {
        if (clip.getFilterType() != ETEFilterType.TEFilterType_Swing_Transition) {
            return;
        }
         
        if (this.isFrameSampling) {
            this.unUsedClips.forEach((uClip, _) => {
                uClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
            });
        }
                
        this.filterVideoClips.forEach((fviClip, _) => {
            let effectClips = fviClip.getEffectClipsListByType(ETEFilterType.TEFilterType_All);
            let smartLightClips = fviClip.getEffectClipsListByType(ETEFilterType.TEFilterType_Smart_Lighting);
            if (this.isFrameSampling) {
                if (smartLightClips) {
                    smartLightClips.forEach((eClip, _) => {
                        eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
                    });
                }
                // check if is fliter effect clip or is adjustment effect clip
                if (effectClips) {
                    effectClips.forEach((eClip, _) => {
                        if (eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Video_Filter || eClip.getFilterSubType() == ETEFilterSubType.TEFilterSubType_Color_Adjust) {
                            eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
                        }
                    });
                }
            } else {
                if (effectClips) {
                    effectClips.forEach((eClip, _) => {
                        eClip.setParamValue(CC_JS_SCRIPT_SET_SEGMENT_VISIBLE, true);
                    });
                }
            }
        });
    }
};
var CCJsScript = new CCJsScriptClass();

