

local mpairs = function(input)
  local iter;
  local mt = getmetatable(input);
  local typeinput = type(input);
  if not mt then
    iter = next;
  else
    if type(input) == "table" then
      local index = 0;    
      iter = function (input)
        index = index + 1;
        local key = mt.__members[index];
        if key == nil then
          return nil,nil;
        else
          return key, input[key];
        end
      end
    else
      iter = function(input, key)
        local vt;
        repeat
          key, vt = next(mt, key);
          if key == nil or vt == nil then 
            mt = mt.__parent;
          end
        until not mt or type(vt) == "userdata";
        --until mt == nil (not key or type(vt) == "userdata");
        if key == nil then
          return nil,nil;
        else
          return key, input[key];
        end
      end  
    end
  end  
  return iter, input, nil;
end

return mpairs;


--demo
--[[

local object = require "venuscore.rtti.object"


local basetype =  object:extend("basetype");
basetype:MemberRegister("test_bool");
basetype:MemberRegister("test_num");
basetype:MemberRegister("test_table");



function basetype:new(name)
  self.test_bool = false;
  self.test_num = 12.43;
  self.test_table = {1,2,3}
  self.test_internal = "internal";
end


local drivertype =  basetype:extend("drivertype");
--drivertype:MemberRegister("test_bool");--基类已经导出这里不需要再次导出
drivertype:MemberRegister("test_newnumber");
drivertype:MemberRegister("test_string");



function drivertype:new(name)
  drivertype.super.new(self)
  self.test_bool = true;--将基类的变量覆盖掉
  self.test_newnumber = 21.17;
  self.test_string = "i'm string";
end

  self.base = venuscore.basetype();
  for key, value in venuscore.mpairs(self.base) do
    LOG(key);
  end  
  self.driver = venuscore.drivertype();
  for key, value in venuscore.mpairs(self.driver) do
    LOG(key);
  end
  for key, value in venuscore.mpairs(self.render.trans) do
    LOG(key);
  end  
return {basetype, drivertype};


]]--