local libvenuscore = require "libvenuscore"
local VenusBehavior = require "venuscore.behavior.venusbehavior"
local ContentManager = require "apolloengine.content.contentmanager"

local loaded = {}

return function(path)
  local status;
  local fullpath = libvenuscore.IFileSystem:PathAssembly(path);
  local callfunction = loaded[fullpath];  
  if not callfunction then
    status, callfunction = pcall(dofile, fullpath)
    if status then
      loaded[fullpath] = callfunction;
    else
      libvenuscore.ILogSystem:Error(callfunction);
      callfunction = nil;
    end
  end
  if callfunction 
    and type(callfunction) == "table" 
    and callfunction.is
    and callfunction:is(VenusBehavior) then
      callfunction._staticID = ContentManager:GenerateUUID();
      return callfunction();
  end
  loaded[fullpath] = nil;
  ERROR(string.format("error to load script %s", path));
end