local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local torch = require "torch"

local zVariations = Operator:extend();
local EPSILON = 1e-5;

function zVariations:new(lastpos, currentpos)
  zVariations.super.new(self, currentpos);
  self.lastpos = lastpos:R();
  self.vcount = self.lastpos:size()[1] * self.lastpos:size()[2];--位置变量的个数
  self.rcount = self.lastpos:size()[1];
end

function zVariations:Caculate(currentpos)
  local zlast = self.lastpos[{{}, 3}];
  local zcurrent = currentpos[{{}, 3}];
  return zlast - zcurrent;
end

--这个矩阵过于稀疏，考虑直接把pow加到这个方法内，输出一个1*1的结果，这样J的维度大幅度变小
function zVariations:Derivative(pr)
  local J = torch.zeros(self.rcount, self.vcount);
  for i=1, self.rcount do
    J[{i, i*3}] = -1;
  end
  return J;
end

return zVariations;