local venusjson = require "venusjson"
local venuscore = require "venuscore"

local torch = require "torch"
local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"

local PoseExp = Operator:extend();

function PoseExp:new(...)
    PoseExp.super.new(self,...);
end

function PoseExp:Caculate( param1,param2 )
  self.mulcache = torch.cmul(param1, param2);
  self.expcache = self.mulcache:exp();
  return  self.expcache;
end

function PoseExp:Derivative(param)
  local ret = torch.Tensor(param:size()[2],param:size()[2]):fill(0);
  if self:HasParamForD(1,param) then
    for i=1,param:size()[2] do
      ret[i][i] = self.expcache[1][i]*self.paramcache[2]:R()[1][i]
    end
  else
    for i=1,param:size()[2] do
      ret[i][i] = self.expcache[1][i]*self.paramcache[1]:R()[1][i]
    end
  end
  return ret;
end

return PoseExp;