local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local PublishImage = BlueNode:extend();

local likeapp
if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

---- 游戏运行模式
function PublishImage:new(...)
  PublishImage.super.new(self, ...)
end

function PublishImage:_OnUpdate(args)

  local entity = args[1]
  local x = 0 ;
  local y = 0 ;
  local texId = 0 ;

  if entity ~= nil and entity ~= "" and type(entity) ~= 'userdata' then
    local size = entity:GetSize();
    x = size.mx
    y = size.my
    texId = entity:GetResourceID();
  end

  if likeapp then
    likeapp.AI:PublishImageCB(x, y, texId);
  else
    WARNING("PublishImage, blocked");
    local libvenuscore = require "libvenuscore"
    local path = libvenuscore.IFileSystem:PathAssembly(SystemDirectories["scene_asset"]);
    libvenuscore.IApplication:GetMainWindow():OpenFileDialog(tostring(x).."_"..tostring(y).."_"..tostring(texId), path);
    libvenuscore.IApplication:GetMainWindow():Update(); -- 挂起 等待
    libvenuscore.IApplication:GetMainWindow():GetSelectedPath(); -- 忽略结果
  end
end

---- 编辑器模式
---  function FEncoder:SetFieldReference(name,value) 不能空串
PublishImage:RegisterInput(1, AE.TextureEntity:RTTI(), "Texture", "图片", "DEVICE_CAPTURE");

PublishImage:RegisterExecInput(1, "exec", "执行");
PublishImage:RegisterExecOutput(1, "exec", "执行");
PublishImage:SetFunctionName("Publish Image");
PublishImage:SetFunctionType(BD.USER_INTERFACE_NODE);

return PublishImage

