local BD = require "bluecore.bluedefined"
local TN = require "bluecore.base.transaction_node"
local Types = require "venuscore.rtti.types"
local VC = require "venuscore"
local GetUserName = TN:extend();

function GetUserName:new(...)
  GetUserName.super.new(self, ...)
end

function GetUserName:_OnJsonToResult(jsonTbl)
  return jsonTbl["name"]
end

-- override
function GetUserName:_OnCheckReady(outputResults)
  local result = outputResults ~= nil and outputResults[1] ~= nil and type(outputResults[1]) == 'string'
  if not result then
    WARNING("[GetUserName] _OnCheckReady not ready "..tostring(outputResults));
  end
  return result
end

-- override
function GetUserName:_OnRequestJson()
  return "{}" -- do need extra info
end

-- override
function GetUserName:_OnRequestType()
  return BD.RequestType.NICK_NAME
end

-- add
GetUserName:RegisterOutput(1, Types.StringType, "name", "user name")

GetUserName:SetFunctionName("Get User Name");

return GetUserName;

