


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mf = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetLocalRotation = BlueNode:extend();

---- 游戏运行模式
function SetLocalRotation:new(...)
  SetLocalRotation.super.new(self, ...)
end

function SetLocalRotation:_OnUpdate(args)
  local transformComponent_target = args[1];
  local rotation = args[2];
  transformComponent_target:SetLocalRotation(rotation);

  return true;
end



---- 编辑器模式

SetLocalRotation:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
SetLocalRotation:RegisterInput(2, mf.Quaternion:RTTI(), "rotation", "设置target在模型坐标系下的旋转", mf.Quaternion());

SetLocalRotation:RegisterOutput(1, Types.BoolType, "result", "设置成功返回true");

SetLocalRotation:RegisterExecInput(1, "exec", "执行");

SetLocalRotation:RegisterExecOutput(1, "exec", "执行");

SetLocalRotation:SetFunctionName("SetLocalRotation");


return SetLocalRotation ;

