local AE = require "apolloengine"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local GetLocalEulerAngle = BlueNode:extend();

function GetLocalEulerAngle:new(...)
  GetLocalEulerAngle.super.new(self, ...)
end

function GetLocalEulerAngle:_OnUpdate(args)
  local transformTarget = args[1];
  local result = transformTarget.LocalEularAngle
  if args[2] then
    return result:x()*180.0/math.pi, result:y()*180.0/math.pi, result:z()*180.0/math.pi;
  else
    return result:x(), result:y(), result:z();
  end
end

GetLocalEulerAngle:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetLocalEulerAngle:RegisterInput(2, Types.BoolType, "is degree", "true:degree, false:radian ", true);

GetLocalEulerAngle:RegisterOutput(1, Types.FloatType, "x", "x");
GetLocalEulerAngle:RegisterOutput(2, Types.FloatType, "y", "y");
GetLocalEulerAngle:RegisterOutput(3, Types.FloatType, "z", "z");

GetLocalEulerAngle:SetFunctionName("Get Local Euler Angle");

return GetLocalEulerAngle;

