local AE = require "apolloengine"
local MF = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local BU = require "bluecore.blueutility"
local BD = require "bluecore.bluedefined"
local BluePinInfo = require "bluecore.bluepininfo"
local SetQuad2dUV = BlueNode:extend();

function SetQuad2dUV:new(...)
    SetQuad2dUV.super.new(self, ...);
end

function SetQuad2dUV:ChangeRenderObjectEntity(args)
  local renderComponent = args[1];
  local vertexStream = AE.VertexStream();
  vertexStream:SetVertexType(AE.ShaderEntity.ATTRIBUTE_POSITION,
    AE.VertexBufferEntity.DT_FLOAT,
    AE.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  vertexStream:SetVertexType(AE.ShaderEntity.ATTRIBUTE_COORDNATE0,
    AE.VertexBufferEntity.DT_FLOAT,
    AE.VertexBufferEntity.DT_HALF_FLOAT,
    2);
  vertexStream:ReserveBuffer(4);
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_POSITION, MF.vector4(-1,-1,0,1));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_POSITION, MF.vector4(-1,1,0,1));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_POSITION, MF.vector4(1,-1,0,1));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_POSITION, MF.vector4(1,1,0,1));

  --y坐标颠倒解决反向问题
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_COORDNATE0, MF.vector2(args[2].mx, 1.0-args[2].my));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_COORDNATE0, MF.vector2(args[3].mx, 1.0-args[3].my));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_COORDNATE0, MF.vector2(args[4].mx, 1.0-args[4].my));
  vertexStream:PushVertexData(AE.ShaderEntity.ATTRIBUTE_COORDNATE0, MF.vector2(args[5].mx, 1.0-args[5].my));

  local indexStream = AE.IndicesStream();
  indexStream:SetIndicesType(AE.IndicesBufferEntity.IT_UINT16);
  indexStream:PushIndicesData(0);
  indexStream:PushIndicesData(3);
  indexStream:PushIndicesData(1);
  indexStream:PushIndicesData(0);
  indexStream:PushIndicesData(2);
  indexStream:PushIndicesData(3);
  --2   4
  --1   3

  renderComponent:ChangeRenderObjectEntity(AE.RenderObjectMeshMetadate(
      AE.RenderComponent.RM_TRIANGLES,
      AE.ReferenceVertexMetadata(AE.VertexBufferEntity.MU_DYNAMIC, vertexStream),
      AE.ReferenceIndicesMetadata(AE.VertexBufferEntity.MU_DYNAMIC, indexStream)));
  --renderComponent:FlushVertexBuffer(vertexStream);
end

function SetQuad2dUV:FlushVertexBuffer(args)
  local renderComponent = args[1];
  local vertexStream = renderComponent:GetVertexStream();
  local idx = vertexStream:GetAttributeIndex(AE.ShaderEntity.ATTRIBUTE_COORDNATE0);
  vertexStream:ChangeVertexDataWithAttributeFast(idx, 1, MF.vector2(args[2].mx, 1.0-args[2].my));
  vertexStream:ChangeVertexDataWithAttributeFast(idx, 2, MF.vector2(args[3].mx, 1.0-args[3].my));
  vertexStream:ChangeVertexDataWithAttributeFast(idx, 3, MF.vector2(args[4].mx, 1.0-args[4].my));
  vertexStream:ChangeVertexDataWithAttributeFast(idx, 4, MF.vector2(args[5].mx, 1.0-args[5].my));
  vertexStream:SetReflushInterval(1, 4);
  renderComponent:ChangeVertexBuffer(vertexStream);
end

function SetQuad2dUV:_OnUpdate(args)
   
  local renderComponent = args[1];
  local isKeepSource= renderComponent:isKeepSource();
  if isKeepSource then
    --WARNING("isKeepSource");
    self:FlushVertexBuffer(args);
  else
    --WARNING("createnew");
    self:ChangeRenderObjectEntity(args);
    renderComponent:SetKeepSource(true);
  end

  
end

SetQuad2dUV:RegisterInput(1, AE.RenderComponent:RTTI(), "target", "渲染组件", BlueSelf());

SetQuad2dUV:RegisterInput(2, MF.vector2:RTTI(), "leftdown", "采样坐标(左下)", MF.vector2(0.0, 0.0));
SetQuad2dUV:RegisterInput(3, MF.vector2:RTTI(), "leftup", "采样坐标(左上)", MF.vector2(0.0, 1.0));
SetQuad2dUV:RegisterInput(4, MF.vector2:RTTI(), "rightdown", "采样坐标(右下)", MF.vector2(1.0, 0.0));
SetQuad2dUV:RegisterInput(5, MF.vector2:RTTI(), "rightup", "采样坐标(右上)", MF.vector2(0.0, 1.0));


SetQuad2dUV:RegisterExecInput(1, "exec", "Execute");

SetQuad2dUV:RegisterExecOutput(1, "exec", "Execute");

SetQuad2dUV:SetFunctionName("SetQuad2dUV");

return SetQuad2dUV;




