
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local SetActiveReserveFBO = BlueNode:extend();

function SetActiveReserveFBO:new(...)
    SetActiveReserveFBO.super.new(self,...);
  end
  
function SetActiveReserveFBO:_OnUpdate(args)
    args[1].IsReserveFrames = args[2];
end


SetActiveReserveFBO:RegisterInput(1, apolloengine.CameraComponent:RTTI(), "target", "相机节点", BlueSelf());
SetActiveReserveFBO:RegisterInput(2, Types.BoolType, "status", "设置是否开启历史帧", true);

SetActiveReserveFBO:RegisterExecInput(1, "exec", "Execute");

SetActiveReserveFBO:RegisterExecOutput(1, "exec", "Execute");


SetActiveReserveFBO:SetFunctionName("SetReserveFBOActive");

return SetActiveReserveFBO ;