require "lfs"

local venuscore = require "venuscore"
local BD = require "bluecore.bluedefined"
local BS = require "bluecore.bluesingle"
local BU = require "bluecore.blueutility"

local BluePrintManager = {}

--get filename
function BluePrintManager:_GetFileName(str)
  local idx = str:match(".+()%.%w+$")
  if(idx) then
    return str:sub(1, idx-1)
  else
    return str
  end
end

function BluePrintManager:_GetExtension(str)
  return str:match(".+%.(%w+)$")
end

function BluePrintManager:WalkThrough(root_path, luaPath, subAllNode, subrttiToNode)
  for entry in lfs.dir(root_path) do
    if entry ~= '.' and entry ~= '..' then
      local path = root_path .. '/' .. entry --apolloengine/
      local attr = lfs.attributes(path)
      local filename = self:_GetFileName(entry)
      local nextLuaPath = luaPath.."."..filename

      if attr.mode ~= 'directory' then
        local postfix = self:_GetExtension(entry)
        if postfix == "lua" then
          local node = require(nextLuaPath);
          local nodetype = node:GetFunctionType();
          local isHide = node:isHide();
          if not isHide then
            self:_ParseLuaFile(nextLuaPath, node:GetName(), nodetype, subAllNode, subrttiToNode)
          end
        end
      else
        subAllNode[entry] = {};
        subrttiToNode[BD.BLUE_MGR_DIR] = subrttiToNode[BD.BLUE_MGR_DIR] or {};
        subrttiToNode[BD.BLUE_MGR_DIR][entry] = {};
        self:WalkThrough(path, nextLuaPath, subAllNode[entry], subrttiToNode[BD.BLUE_MGR_DIR][entry])
      end
    end
  end
end

function BluePrintManager:_CollectBluePrint()

  BS.init();

  self.allNode = {}
  self.rttiToNodeNew = {};

  local absolutePath = venuscore.IFileSystem:PathAssembly("comm:") .. "/script" .. "/bluecore" .. "/bluenodes"

  -- short_path 是相对于与common/script目录的路径 用于require
  self:WalkThrough(absolutePath, "bluecore.bluenodes" , self.allNode, self.rttiToNodeNew);

  return

end

function BluePrintManager:_ParseLuaFile(_luaPath, _blueNodeName, _blueNodeType, subAllNode, subrttiToNode)

    LOG("parse _luaPath .. ".._luaPath)

    local tbl = require (_luaPath)

    local ctxInfo =
    {
      luaPath = _luaPath,
      blueNodeName = _blueNodeName,
      blueNodeType = _blueNodeType,
    }

    --table.insert(self.allNode, info); -- 在蓝图类上右键 应该可以显示所有的节点
    table.insert(subAllNode, ctxInfo); -- 在蓝图类上右键 应该可以显示所有的节点

    local inputInfos = tbl:GetInputsType()
    BU:SetClassifyNode(inputInfos, BD.BLUE_MGR_INPUT, ctxInfo, subrttiToNode);

    local outputInfos = tbl:GetOutputsType()
    BU:SetClassifyNode(outputInfos, BD.BLUE_MGR_OUTPUT, ctxInfo, subrttiToNode);

    local execInputInfos = tbl:GetExecInput()
    BU:SetClassifyNode(execInputInfos, BD.BLUE_MGR_INPUT, ctxInfo, subrttiToNode);

    local execOutputInfos = tbl:GetExecOutput()
    BU:SetClassifyNode(execOutputInfos, BD.BLUE_MGR_OUTPUT, ctxInfo, subrttiToNode);

end




-- 返回所有的节点
function BluePrintManager:GetAllNode()
  return self.allNode
end


-- 返回分类节点
function BluePrintManager:GetClassifyNode()
  return self.rttiToNodeNew
end


--此函数用于一开始统计所有类型的节点 已经引脚信息 方便从一个node拖出来create的时候显示能够连线的节点列表
BluePrintManager:_CollectBluePrint();

return BluePrintManager ;