local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Types = require "venuscore.rtti.types"
local BluePrint = require "bluecore.blueprint"
local BD = require "bluecore.bluedefined"
local BR = require "bluecore.core.blue_rtti"
local BlueDebug = require "bluecore.debug.bluedebug"
local BFPI = require "bluecore.bluefuncpininfo"
-- 这个蓝图类 对应的是  Node
local BlueFunction = BluePrint:extend("BlueFunction");
-- 用于编译打印信息
local DEBUG_E_DOG = "-->"
local DEBUG_D_DOG = "|--"

BlueFunction:MemberRegister("startNodeUid");
BlueFunction:MemberRegister("endNodeUid");
BlueFunction:MemberRegister("inputInfoList");
BlueFunction:MemberRegister("outputInfoList");
BlueFunction:MemberRegister("ftnUid");
BlueFunction:MemberRegister("dependencies");
BlueFunction:MemberRegister("isNeedReset");  --每次调用前是否需要重置node状态和local变量值  UE重置，但设计师有时候需要不重置


--FIXME(hjh) UE的蓝图函数如果使用Sequence节点 第一个执行输出引脚连接output  则后面的执行输出引脚连接的节点不会执行
--           Venus会执行完所有执行引脚连接的节点才返回函数返回值

--BlueFunction要考虑全局函数和局部函数
--全局函数不属于任何blueprint
function BlueFunction:new(blueprint, name, ftnUid)
  LOG("BlueFunction:new");
  BlueFunction.super.new(self);

  self.ftnUid = ftnUid;--用来定位blueprint对应的实例节点~
  self._blueprint = blueprint; -- 非nil是个成员函数 nil是个全局函数
  --self.isGlobalFunction = blueprint and false or true;

  self.funcName = name;
  self.startNodeUid = 0;
  self.endNodeUid = 0;
  self.inputInfoList = {};
  self.outputInfoList= {};
  self.refNodeList = setmetatable({} , { __mode = "v"});
  --记录要跟踪的所有实例节点 弱引用 这样删除节点 不用通知函数
  --记录资源依赖/记得反序列化补全
  self.dependencies = {};
  self.isNeedReset = true;
end

-- override Blueprint.EditorCreate 不回调blueprint的 仅在编辑器中new后调用
function BlueFunction:EditorCreate()
  self._CreatedDone = true
  if self._blueprint ~= nil then -- 只有成员函数才要加入到类信息中
    BR.AppendBlueFunctionToClassInfo(self._blueprint, self);
  end
end

-- EditorCreate -> Awake -> SetupPresetNode
-- 不能直接在BlueFunction:EditorCreate来创建蓝图节点
-- 避免 BlueNode:OnDeserializePost, BlueNode.EditorCreate 同时调用冲突
-- 蓝图先创建好,才能创建蓝图节点
function BlueFunction:SetupPresetNode()

  local inputNode = self:AddBluePrintNode("bluecore.functioncore.func_input_node", 50, 50);
  local outputNode = self:AddBluePrintNode("bluecore.functioncore.func_output_node", 200, 200);

  self.startNodeUid = inputNode.uid;
  self.endNodeUid = outputNode.uid;
end

function BlueFunction:IsNeedResetWhenCall()
  return self.isNeedReset;
end

function BlueFunction:GetName()
  return self.funcName;
end

function BlueFunction:SetName(newName)
  local oldName = self.funcName
  self.funcName = newName;
  if self._CreatedDone then
    -- notify  FuncInstanceNode FunctionInputNode FunctionOutputNode FuncInfo but not FtnCallNode
    for _,notify in pairs(self.refNodeList) do
      notify:NameChanged(oldName, newName)
    end
  end

end

function BlueFunction:IsGlobalFunction()
  return not self._blueprint;
end

function BlueFunction:RefreshDependencyResource(oldliteral, literal)
  if self:IsGlobalFunction() then --如果是全局函数则需要记录资源依赖
    --移除旧的 添加新的
    self:_RemoveInputDependency(oldliteral)
    self:_AddInputDependency(literal);
  end
end


--[[function BlueFunction:SetInputPinLiteral(pin_uid, literal)
  --local pin = self.bluePrintAllList[pin_uid]
  --local oldLiteral = pin.literal;
  local oldLiteral = BlueFunction.super.SetInputPinLiteral(self, pin_uid, literal);
  if self:IsGlobalFunction() then --如果是全局函数则需要记录资源依赖
    --移除旧的 添加新的
    self:_RemoveInputDependency(oldLiteral)
    self:_AddInputDependency(literal);
  end
  return oldLiteral;
end]]--

function BlueFunction:GetDependencies()
  return self.dependencies;
end

function BlueFunction:_AddInputDependency(literal)
  if type(literal) == 'table' then
    for _,val in pairs(literal) do
      table.insert(self.dependencies, val);
    end
  else
    table.insert(self.dependencies, literal);
  end
end

function BlueFunction:_RemoveInputDependency(oldLiteral)
  if type(oldLiteral) == 'table' then
    for _,val in pairs(oldLiteral) do
      for idx,val2 in pairs(self.dependencies) do
        if val2 == val then
          table.remove(self.dependencies, idx);
          break;
        end
      end
    end
  else
    for idx,val in pairs(self.dependencies) do
      if val == oldLiteral then
        table.remove(self.dependencies, idx);
        break;
      end
    end
  end
end

function BlueFunction:AddRefactor(node)

  if _KRATOSEDITOR then
    for _, n in pairs(self.refNodeList) do
      if n == node then
        error("BlueFunction:AddRefactor duplicate ");
      end
    end
  end

  table.insert(self.refNodeList, node);
end

function BlueFunction:RemoveRefactor(node)
  for pos,refNode in pairs(self.refNodeList) do
    if refNode == node then
      table.remove(self.refNodeList, pos);
      break;
    end
  end
end

-- for global function refNodeList include func_call_node.lua
function BlueFunction:GetRefactorList()
  return self.refNodeList;
end

--获取input节点
function BlueFunction:GetInputInfo()
    return self.inputInfoList;
end

function BlueFunction:GetOutputInfo() --只是用来反射和同步真正的bluepininfo内容
    return self.outputInfoList;
end

function BlueFunction:GetFunctionOutput()
  local endNode = self.bluePrintNodeList[self.endNodeUid];
  return endNode.outputResults;
end


function BlueFunction:ChangeInfo(reflectInfo, type, val, isInput)
  --寻找目标索引 以及info是输入还是输出
  local reflectIdx = nil;
  --local targetNode = nil;

  local searchInfoList = isInput and self.inputInfoList or self.outputInfoList;
  --local targetNodeUid = isInput and self.startNodeUid or self.endNodeUid;
  for k,v in pairs(searchInfoList) do
    if v == reflectInfo then
      reflectIdx = k;
      break;
    end
  end

  -- func_input_node / func_output_node
  --targetNode = self.bluePrintNodeList[targetNodeUid];
  --targetNode:InfoChange(reflectIdx, type, val, isInput);

  --回调所有函数调用节点
  --反射面板的输入默认值如果改了会影响实例节点的常量值  反之则否
  for __,node in pairs(self.refNodeList) do
    node:InfoChange(reflectIdx, type, val, isInput);
  end

end



function BlueFunction:AddBlueFunctionInfo(input)

  local reflectInfo = nil;
  local existNum
  if input then --增加inputnode的时候实际增加output引脚信息~
    existNum = #self.inputInfoList;
    reflectInfo = BFPI(mathfunction.vector3:RTTI():GetTypeName(), false);
    reflectInfo:EditorCreate(true, "input"..tostring(existNum + 1), "No Tips", self:_NextID());
    reflectInfo:SetOwner(self);
    table.insert(self.inputInfoList, reflectInfo);
  else
    existNum = #self.outputInfoList;
    reflectInfo = BFPI(mathfunction.vector3:RTTI():GetTypeName(), false);
    reflectInfo:EditorCreate(false, "output"..tostring(existNum + 1), "No Tips", self:_NextID());
    reflectInfo:SetOwner(self);
    table.insert(self.outputInfoList, reflectInfo);
  end

  -- bluefunc blue_func_node func_input_node func_output_node
  for __,node in pairs(self.refNodeList) do
    node:EditorPinAdd(input, reflectInfo);
  end

  return existNum + 1;

end

--移除reflectInfo 对应的引脚连线以及引脚本身也要删除 实例节点的对应内容也要删除
function BlueFunction:DeleteBlueFunctionInfo(isInput, idx)
  local reflectInfo = nil;
  if isInput then
    --这里需要回调~  对应的连线需要先删除
    LOG("------delete------")
    reflectInfo = table.remove(self.inputInfoList, idx);
  else
    reflectInfo = table.remove(self.outputInfoList, idx);
  end

  -- bluefunc blue_func_node func_input_node func_output_node
  for __,node in pairs(self.refNodeList) do
    node:EditorPinDelete(isInput, idx);
  end
  return reflectInfo;
end


--bluefunction调用其他函数
--[[function BlueFunction:CreateFunctionInstance(funcType, ftnUid, libUid, pos_x, pos_y) --要考虑函数模板引用了其他的函数

  local newNode
  if funcType == BD.FuncType.LOCAL then
    local comp = self.Node:GetComponent(apolloengine.Node.CT_BLUEPRINT);
    newNode = self:AddBluePrintNode("bluecore.functioncore.func_inst_node", pos_x, pos_y, funcType, ftnUid, libUid, comp);
  else
    --TODO(hhl)  全局函数 只能调用同一个全局函数库中的函数
    local rootNode = self.Node:GetRoot();
    local comp = rootNode:GetComponent(apolloengine.Node.CT_BLUEPRINT);
    local blueGraph = comp.Instances[BD.LuaPath];
    newNode = self:AddBluePrintNode("bluecore.functioncore.func_inst_node", pos_x, pos_y, funcType, ftnUid, libUid, comp);
  end
  return newNode;
  -- body
end]]--


function BlueFunction:_PreCompileCode()

  self.super._PreCompileCode(self);
  local outputNode = self.bluePrintNodeList[self.endNodeUid];
  outputNode.outputResults = {};
  for _,input in pairs(outputNode.inputs) do
    table.insert(outputNode.outputResults, input.literal);
  end

end


function BlueFunction:CompileCode()

  WARNING("starting to compile bluefunction");
  -- Step 0.清除之前的Compile信息
  self:_PreCompileCode();

  if self.runTime ~= nil and self.runTime.lastVarArray ~= nil then
    for varName, value in pairs(self.runTime.lastVarArray) do
      self[varName] = nil
    end
  end

  -- 局部变量 如果是Node/Component/BlueprintType也必须有初始化值(不能为nil)
  -- 如果变量编译错误要记录在errorMessage显示出来
  self.runTime = {} -- 准备好运行时
  self.runTime.lastVarArray = {}
  for _, variable in pairs(self.bluePrintVariableList) do
    local rtti = variable:GetRtti()
    local name = variable:GetName()
    if variable.is_array then
      local varValue = {}
      self.runTime.lastVarArray[name] = varValue
      rtti = rtti:GetElementType();
      for _, wrap in ipairs(variable.default_value) do
        local value = BR.Create(rtti, wrap.value)
        if value == nil then
          local errorStr = string.format("function %s local variable(array) %s value is nil", self:GetName(), variable:GetDisplayName());
          self.errorMessage = self.errorMessage and self.errorMessage.."\n"..errorStr or errorStr;
          self.compileFlag = false
          return self.compileFlag
        end
        table.insert(varValue, value)
      end
      self[name] = varValue;
    else
      local value = BR.Create(rtti, variable.default_value)
      if value == nil then
        local errorStr = string.format("function %s local variable %s value is nil", self:GetName(), variable:GetDisplayName());
        self.errorMessage = self.errorMessage and self.errorMessage.."\n"..errorStr or errorStr;
        self.compileFlag = false
        return self.compileFlag
      end
      self.runTime.lastVarArray[name] = value
      self[name] = value;
    end
  end

  -- 创建执行链和解析输入依赖
  local startNode = self.bluePrintNodeList[self.startNodeUid];
  self:_DoExecDependency(startNode, DEBUG_E_DOG)
  if not self.compileFlag then
    ERROR("[CompileCode] fail to _DoExecDependency of BlueFunction " .. tostring(self.funcName))
  else
    -- 生成事件对应的函数/执行链
    self.runTime.OnUpdate = function(self, args) --传入实例引脚的参数
      -- ... is deltaTime
      if self.isNeedReset then --局部变量/蓝图节点状态每次使用之前是否需要重置
        for varName, value in pairs(self.runTime.lastVarArray) do
          self[varName] = value ;
        end
        for _,bluenode in pairs(self.bluePrintNodeList) do
          bluenode:Reset();
        end
      end

      -- 把函数的参数给到第一个节点(事件节点)
      if _KRATOSEDITOR  then
        local BuEd = require "bluecore.editor.blueutility_ed"
        BuEd:BlueDebugYield(startNode);
      end

      --更新事件节点的引脚输出值  事件节点在事件发生时候不用获取引脚参数
      startNode.outputResults = startNode:_OnUpdate(args) or {}

      -- 由事件节点决定下一个执行的是哪一个node
      local nextIdx = startNode:_OnNextBranch();

      -- 事件节点返回0 不执行后续节点
      if nextIdx == nil or nextIdx <= 0  then
        --ERROR("[Update] return; out of range, next = " .. tostring(nextIdx))
        return
      end

      -- 事件图表 事件节点后继的执行节点
      local lastNode = startNode;
      local nextIndex = startNode.nextExecIndex[nextIdx];
      local nextNode = startNode.nextExecNodes[nextIdx];

      while nextNode ~= nil
      do
        if _KRATOSEDITOR then
          local linkUid = lastNode.execOutputs[nextIdx].links[1].linkUid;
          self:AddExecLinkList(linkUid);
        end
        nextIdx = nextNode:Update(nextIndex);
        if nextIdx == nil or nextIdx <= 0  then
          --ERROR("[Update] break; out of range, next = " .. tostring(nextIdx))
          break
        end
        lastNode = nextNode;
        nextIndex = nextNode.nextExecIndex[nextIdx];
        nextNode =  nextNode.nextExecNodes[nextIdx];
      end

      self.execLinkList = {}; --调用结束后清除掉ui执行线
    end -- self.EventEntries[name].func
  end

  self._isModify = false ;
  WARNING("finish compiling !")
  return self.compileFlag;

end

-- override blueprint
function BlueFunction:Run()
  self.isrunning = true;
  if not self:IsGlobalFunction() then
    self:_SaveRefNodeStatus();
  end
  self["_OnUpdate"] = self.runTime.OnUpdate
end


function BlueFunction:Stop()
  self.isrunning = false;
  self.execLinkList = {};
  if not self:IsGlobalFunction() then
    self:_ClearRefNodeStatus();
  end
  self["_OnUpdate"] = nil -- stop updating
  if self.bluePrintNodeList ~= nil then
    for _,v in pairs(self.bluePrintNodeList) do
      v:Stop();
    end
  end
end

-- just override Blueprint, do NOT need reset local variable
function BlueFunction:Reset()
  if not self:IsGlobalFunction() then
    if self.bluePrintNodeList ~= nil then
      for _,v in pairs(self.bluePrintNodeList) do
        v:Reset();
      end
    end
    self:_ResetRefNodeStatus();
  end
end

--just override BluePrint
function BlueFunction:_OnDeserialize()

  for _, blueFuncPinInfo in pairs(self.inputInfoList) do
    blueFuncPinInfo:SetOwner(self);
  end

  for _, blueFuncPinInfo in pairs(self.outputInfoList) do
    blueFuncPinInfo:SetOwner(self);
  end

  self._CreatedDone = true

end


-- call from blueprint.blueFunctionList[i]:_OnAwake
function BlueFunction:_OnAwake(node)
  self.Node = node;
  self[BD.THIS] = self.Node;
  LOG("[_OnAwake] BlueFunction self.Node " .. tostring(self.Node))
  self:_AwakeProcess()
end

function BlueFunction:_AwakeProcess()

  self:OnDeserializeDone()

  self:_SaveRefNodeStatus();

  -- 反序列化完成
  LOG("awake it "..tostring(self._isAwake)..","..tostring(self:GetObjectID()))
  self._isAwake = true ;

end

function BlueFunction:GetFuncId()
  return self.ftnUid;
end

-- 从蓝图类中删除成员函数 或者 从函数库中删除全局函数
-- BluePrint:DeleteFunctionByIndex(
-- BlueFtnLib:DeleteLibEd
function BlueFunction:ToBeDeletedEd()

  for _, node in pairs(self.refNodeList) do
    node:ToBeDeletedEd();
  end
  self.refNodeList = setmetatable({} , { __mode = "v"})
end

-- 全局函数离开大场景
function BlueFunction:LeaveCurrentSceneEd()

  -- 清除非本蓝图(函数)的引用,大场景其他蓝图(其他全局函数的引用)
  --local temp =  self.refNodeList;
  --self.refNodeList = setmetatable({} , { __mode = "v"})
  --for _, node in pairs(self.refNodeList) do
  --  if node.graph == self then
  --    table.insert(self.refNodeList, node);
  --  end
  --end

  -- prefab场景不会修改全局函数,直接清空
  self.refNodeList = setmetatable({} , { __mode = "v"})

  -- 暂时 orphan
  self.Node = nil;
  self[BD.THIS] = nil;

end

function BlueFunction:IsLibFunction()
  return self._blueprint == nil
end

function BlueFunction:GetBlueprint()
  return self._blueprint
end

-- 全局函数进入prefab场景
function BlueFunction:EnterNextSceneEd(hostNode)

  self.Node = hostNode;
  self[BD.THIS] = hostNode;
end

BlueFunction:MemberRegister("funcName", Types.BaseType(BlueFunction.GetName, BlueFunction.SetName));

return BlueFunction;