local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
--local ScreenImage = require "behavior3.ScreenImageBehavior"
local AE = require "apolloengine"

local ScreenImageBG = venuscore.VenusBehavior:extend("ScreenImageBG");

function ScreenImageBG:new()
  self.hostCamera = nil;
end

function ScreenImageBG:GetHostCameraResolution()
  local resolution;
  if venuscore.isNil(self.hostCamera) then
    if _KRATOSEDITOR then
      local scene = AE.SceneManager:GetOrCreateScene("facecuteScene"); --previewscene
      local fbo = scene:GetDefaultRenderTarget();
      local tex = fbo:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
      resolution = tex:GetSize();
    else
      resolution = AE.Framework:GetResolution();
    end
  else
    resolution = self.hostCamera.CameraResolution;
  end
  return resolution;
end


function ScreenImageBG:_OnUpdate(def)
  local renderCom = self.Node:GetComponent(AE.Node.CT_RENDER);
  local screenTransCom = self.Node:GetComponent(AE.Node.CT_SCREENTRANSFORM);
  if not renderCom or not screenTransCom then
    return;
  end
  local resolution = self:GetHostCameraResolution();
  renderCom:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
  screenTransCom.WindowAspect = resolution.mx/resolution.my;
  ---ScreenImageBG
  local slotNameList, slot = renderCom:GetUniformParameter(1);
  --local imgSize = slot["_BlendTex"]:GetSize();
  local blendTex = slot["_BlendTex"];
  local isTexRatioChange= false;
  local TexRatioValue = nil;
  local imgSize = mathfunction.vector2(20, 20);
  if blendTex:isTypeOrDriverType(AE.TextureEntity:RTTI()) then
    imgSize = blendTex:GetSize();
  elseif blendTex:isTypeOrDriverType(AE.RenderTargetEntity:RTTI()) then
    blendTex = blendTex:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
    imgSize = blendTex:GetSize(); --对应摄像机分辨率
  end
  if imgSize.mx/imgSize.my ~= screenTransCom.TexAspect then
    isTexRatioChange = true;
    TexRatioValue = imgSize.mx/imgSize.my;
    screenTransCom.TexAspect = TexRatioValue;
    renderCom:SetParameter("_TextureRatio", mathfunction.vector1(TexRatioValue));
  end
  renderCom:SetParameter("_XRepeat", mathfunction.vector1(resolution.mx/imgSize.mx));
  renderCom:SetParameter("_YRepeat", mathfunction.vector1(resolution.my/imgSize.my));
  renderCom:SetParameter("_GaussianStep", mathfunction.vector2(1.0/resolution.mx, 1.0/resolution.my));


  if _KRATOSEDITOR then
    --同步Scene场景
    local editSystem = require "window.editor.system.editsystem";
    local Command = require "window.editor.command.command";
    local editScene = editSystem:GetEditScene();
    local cmd = Command();
    cmd:SetSceneID(editScene:GetStaticID());
    local renderComScene =  cmd:GetContent(renderCom:GetContentPath());
    local screenTransComScene =  cmd:GetContent(screenTransCom:GetContentPath());
    renderComScene:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
    screenTransComScene.WindowAspect = resolution.mx/resolution.my;
    renderComScene:SetParameter("_XRepeat", mathfunction.vector1(resolution.mx/imgSize.mx));
    renderComScene:SetParameter("_YRepeat", mathfunction.vector1(resolution.my/imgSize.my));
    renderComScene:SetParameter("_GaussianStep", mathfunction.vector2(1.0/resolution.mx, 1.0/resolution.my));
    if isTexRatioChange then
      screenTransComScene.TexAspect = TexRatioValue;
      renderComScene:SetParameter("_TextureRatio", mathfunction.vector1(TexRatioValue));
    end
  end
end

function ScreenImageBG:PhotoUploadRecall(tex, redirectName) 
  local renderCom = self.Node:GetComponent(AE.Node.CT_RENDER);
  local screenTransCom = self.Node:GetComponent(AE.Node.CT_SCREENTRANSFORM);
  local slotNameList, slot = renderCom:GetUniformParameter(1); --screenImageNode只有一个matentity
  if slot["_BlendTex"]:GetName() == redirectName then --所用的纹理是改变的重定向纹理
    local texSize = tex:GetSize();
    renderCom:SetParameter("_TextureRatio", mathfunction.vector1(texSize.mx/texSize.my)); --设置给shader...
    screenTransCom.TexAspect = texSize.mx/texSize.my; --计算local scale

    local resolution = self:GetHostCameraResolution();

    renderCom:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
    screenTransCom.WindowAspect = resolution.mx/resolution.my;
    
    ----ScreenImageBG
    local imgSize = slot["_BlendTex"]:GetSize();
    renderCom:SetParameter("_XRepeat", mathfunction.vector1(resolution.mx/imgSize.mx));
    renderCom:SetParameter("_YRepeat", mathfunction.vector1(resolution.my/imgSize.my));

  end
end

function ScreenImageBG:GetCamera()
  return self.hostCamera;
end

function ScreenImageBG:SetCamera(hostCamera)
  self.hostCamera = hostCamera;
end

ScreenImageBG:MemberRegister("hostCamera",
  venuscore.ScriptTypes.ReferenceType(
    AE.CameraComponent:RTTI(),    
    ScreenImageBG.GetCamera,
    ScreenImageBG.SetCamera
)); 




return ScreenImageBG;