local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local clear = {}
clear.Do = 0;

clear.Queue = 320;

--效果参数--


clear.blurAlpha_params = 0.6;

clear.sharpen_params = 0.05;

clear.smoothScaleFactor_params = 1.0;
--效果参数结束--

clear.btblurRenderObj = 0;
clear.btedgeRenderObj = 0;
clear.btbluralpha1RenderObj = 0;
clear.btbluralpha2RenderObj = 0;
clear.btfuseRenderObj = 0;

clear.btblurMaterial = 0;
clear.btedgeMaterial = 0;
clear.btbluralpha1Material = 0;
clear.btbluralpha2Material = 0;
clear.btfuseMaterial = 0;

function clear:Initialize(host, size)
    
    self.texBlurWidthOffset1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset1");
    self.texBlurWidthOffset2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset2");
    self.texBlurWidthOffset3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurWidthOffset3");

    self.texBlurHeightOffset1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset1");   
    self.texBlurHeightOffset2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset2");
    self.texBlurHeightOffset3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "texBlurHeightOffset3"); 

    self.widthOffset = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "widthOffset"); 
    self.heightOffset = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "heightOffset"); 
    self.blurAlpha = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "blurAlpha"); 
    self.sharpen = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "sharpen"); 
    self.smoothScaleFactor = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "smoothScaleFactor");
    
        

    self.TEXTURE_DIFFUSE1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE1");
    self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE2");
    self.TEXTURE_DIFFUSE3 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_DIFFUSE3");
    self.srcImageTex1 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "srcImageTex1");
    self.srcImageTex2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "srcImageTex2");
    self.blurImageTex2 = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "blurImageTex2");
    
    
        
    local pathblur = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btblur.material");  
    self.btblurRenderObj = host:CreateRenderObject();   
    self.btblurMaterial = host:CreateMaterial(pathblur);   

    local pathedge = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btedge.material");  
    self.btedgeRenderObj = host:CreateRenderObject();   
    self.btedgeMaterial = host:CreateMaterial(pathedge);   

    local pathbluralpha1 = venuscore.IFileSystem:PathAssembly("comm:documents/material/BtblurAlpha.material");  
    self.btbluralpha1RenderObj = host:CreateRenderObject();   
    self.btbluralpha1Material = host:CreateMaterial(pathbluralpha1);   

    local pathbluralpha2 = venuscore.IFileSystem:PathAssembly("comm:documents/material/BtblurAlpha.material");  
    self.btbluralpha2RenderObj = host:CreateRenderObject();   
    self.btbluralpha2Material = host:CreateMaterial(pathbluralpha2);   

    local pathfuse = venuscore.IFileSystem:PathAssembly("comm:documents/material/Btfuse.material");  
    self.btfuseRenderObj = host:CreateRenderObject();   
    self.btfuseMaterial = host:CreateMaterial(pathfuse);   

    
   

    self.downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);
    self.blurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, self.downsamplesize );

    self.edgeRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, self.downsamplesize );
    self.alphaRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, self.downsamplesize );
    self.alphaRT2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, self.downsamplesize );
    self.fuseRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_E, size );
   

    local downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);

    self:UpdateSize(size)
    
    self.btfuseMaterial:SetParameter(self.blurAlpha, mathfunction.vector1(self.blurAlpha_params)); 
    self.btfuseMaterial:SetParameter(self.sharpen,  mathfunction.vector1(self.sharpen_params));
    self.btfuseMaterial:SetParameter(self.smoothScaleFactor,  mathfunction.vector1(self.smoothScaleFactor_params));
      
    host:RegisterScriptParameter(self,"blurAlpha_params");
    host:RegisterScriptParameter(self,"sharpen_params");
    host:RegisterScriptParameter(self,"smoothScaleFactor_params");
    
    return self.Queue;
end

function clear:UpdateSize(size)  -- fortest
    self.size = size;
    self.downsamplesize = mathfunction.vector2(size:x()/3,size:y()/3);
    -- self.downsamplesize = mathfunction.vector2(size:x(),size:y());
    self.height= self.downsamplesize:y();
    
    self.hOffset=1.0/self.height;
    self.width=self.downsamplesize:x();
    self.wOffset=1.0/self.width;
    self.hOffset2 = 1.0 / size:y();
    self.wOffset2 = 1.0 / size:x();
    --self.Cartoon:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );

   -- self.Downsample:SetParameter(self.DOWNSAMPLE_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
end


function clear:Resizeview(size)
    self:UpdateSize(size)
end

function clear:Blur(context, Original, Scene, Output)
    --self.blurRT:PushRenderTarget();
    --self.blurRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(self.blurRT, apolloengine.RenderTargetEntity.CF_COLOR);

    self.btblurMaterial:SetParameter(self.texBlurWidthOffset1, mathfunction.vector1(0));
    self.btblurMaterial:SetParameter(self.texBlurHeightOffset1, mathfunction.vector1(self.hOffset));  
    self.btblurMaterial:SetParameter(self.TEXTURE_DIFFUSE1,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
      
    
		
	
    --self.btblur:Draw(pipeline);
    context:Draw(btblurRenderObj, btblurMaterial);
    context:EndRenderPass();
end

function clear:Edge(context, Original, Scene, Output)
    --self.edgeRT:PushRenderTarget();
    --self.edgeRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(self.edgeRT, apolloengine.RenderTargetEntity.CF_COLOR);

    
    self.btedgeMaterial:SetParameter(self.TEXTURE_DIFFUSE2,
        self.blurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btedgeMaterial:SetParameter(self.srcImageTex1,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.btedgeMaterial:SetParameter(self.texBlurWidthOffset2,mathfunction.vector1(self.wOffset) );
    self.btedgeMaterial:SetParameter(self.texBlurHeightOffset2,mathfunction.vector1(0) );

    --self.btedge:Draw(pipeline);
    context:Draw(self.btedgeRenderObj, self.btedgeMaterial);
    context:EndRenderPass();
    
end


function clear:Alpha1(context, Original, Scene, Output)
    --self.alphaRT1:PushRenderTarget();
    --self.alphaRT1:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(self.alphaRT1, apolloengine.RenderTargetEntity.CF_COLOR);

    self.btbluralpha1Material:SetParameter(self.TEXTURE_DIFFUSE3,
        self.edgeRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    
    self.btbluralpha1Material:SetParameter(self.texBlurWidthOffset3,mathfunction.vector1(0 ) );
    self.btbluralpha1Material:SetParameter(self.texBlurHeightOffset3,mathfunction.vector1(self.hOffset) );
    

    --self.btbluralpha1:Draw(pipeline);
    context:Draw(self.btbluralpha1RenderObj, self.btbluralpha1Material);
    context:EndRenderPass();
end


function clear:Alpha2(context, Original, Scene, Output)
    --self.alphaRT2:PushRenderTarget();
    --self.alphaRT2:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    ---- Output:PushRenderTarget();
    ---- Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(self.alphaRT2, apolloengine.RenderTargetEntity.CF_COLOR);


    self.btbluralpha2Material:SetParameter(self.TEXTURE_DIFFUSE3,
        self.alphaRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btbluralpha2Material:SetParameter(self.texBlurWidthOffset3,mathfunction.vector1(self.wOffset ) );
    self.btbluralpha2Material:SetParameter(self.texBlurHeightOffset3,mathfunction.vector1(0) );

    --self.btbluralpha2:Draw(pipeline);
    context:Draw(self.btbluralpha2RenderObj, self.btbluralpha2Material);
    context:EndRenderPass();

end


function clear:Fuse(context, Original, Scene, Output)
    --Output:PushRenderTarget();
    --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.btfuseMaterial:SetParameter(self.srcImageTex2,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    
    self.btfuseMaterial:SetParameter(self.blurImageTex2,
        self.alphaRT2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  

    -- self.btfuse:SetParameter(self.widthOffset,mathfunction.vector1(1.0/self.size:x()) );
    -- self.btfuse:SetParameter(self.heightOffset,mathfunction.vector1(1.0/self.size:y()) );
    self.btfuseMaterial:SetParameter(self.widthOffset,mathfunction.vector1( self.wOffset2));
    self.btfuseMaterial:SetParameter(self.heightOffset,mathfunction.vector1(self.hOffset2) );
    self.btfuseMaterial:SetParameter(self.blurAlpha,mathfunction.vector1(self.blurAlpha_params) );
    self.btfuseMaterial:SetParameter(self.sharpen,mathfunction.vector1(self.sharpen_params) );
    self.btfuseMaterial:SetParameter(self.smoothScaleFactor,mathfunction.vector1(self.smoothScaleFactor_params) );
    --self.btfuse:Draw(pipeline);
    context:Draw(self.btfuseRenderObj, self.btfuseMaterial);
    context:EndRenderPass();
   
end


function clear:Process(context, Original, Scene, Output)
    self:Blur(context, Original, Scene, Output);
    self:Edge(context, Original, Scene, Output);
    self:Alpha1(context, Original, Scene, Output);
    self:Alpha2(context, Original, Scene, Output);
    self:Fuse(context, Original, Scene, Output);
    
end

return clear;

