
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local brightenscale = {}

brightenscale.renderObject = 0;
brightenscale.material = 0;
brightenscale.queue = 100
brightenscale.BrightenScale = mathfunction.vector1(0.0)

function brightenscale:Initialize(host, size)

  self.BRIGHTEN_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "BRIGHTEN_SCALE")

  self.renderObject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/material/brighten_scale.material");
  self:UpdateParameters();
  host:RegisterScriptParameter(self,"BrightenScale");
  
  return self.queue
end

function brightenscale:Resizeview(size)

end

function brightenscale:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget()
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);


  self.material:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()
  --self.renderObject:Draw(pipeline)
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();
end

function brightenscale:UpdateParameters()
  self.material:SetParameter(self.BRIGHTEN_SCALE, mathfunction.vector1(self.BrightenScale:x()*0.01))
end

return brightenscale;