local apollocore = require "apollocore"


local DeviceResource = {}
DeviceResource.ResourceList = {}

DeviceResource.DEVICE_CAPTURE = "DEVICE_CAPTURE";   --摄像头采集数据资源

DeviceResource.DEVICE_SEGMENT = "DEVICE_SEGMENT";   --分割纹理

DeviceResource.DEVICE_STYLETRANSFER = "DEVICE_STYLE";  --风格迁移纹理

DeviceResource.DEVICE_FACEPARSE_LEFT_BROW = "DEVICE_FACEPARSE_LEFT_BROW_";  --五官分割-左眉毛
DeviceResource.DEVICE_FACEPARSE_RIGHT_BROW = "DEVICE_FACEPARSE_RIGHT_BROW_";  --五官分割-右眉毛
DeviceResource.DEVICE_FACEPARSE_LEFT_EYE = "DEVICE_FACEPARSE_LEFT_EYE_"; --五官分割-左眼
DeviceResource.DEVICE_FACEPARSE_RIGHT_EYE = "DEVICE_FACEPARSE_RIGHT_EYE_"; --五官分割-右眼
DeviceResource.DEVICE_FACEPARSE_NOSE = "DEVICE_FACEPARSE_NOSE_"; --五官分割-鼻子
DeviceResource.DEVICE_FACEPARSE_EXT_MOUTH = "DEVICE_FACEPARSE_EXT_MOUTH_"; --五官分割-嘴唇+口腔
DeviceResource.DEVICE_FACEPARSE_INT_MOUTH = "DEVICE_FACEPARSE_INT_MOUTH_"; --五官分割-口腔
DeviceResource.DEVICE_FACEPARSE_LIP = "DEVICE_FACEPARSE_LIP_"; --五官分割-嘴唇
DeviceResource.DEVICE_FACEPARSE_FULL_FACE = "DEVICE_FACEPARSE_FULL_FACE_";  --五官分割-全脸
DeviceResource.DEVICE_FACEPARSE_FORHEAD = "DEVICE_FACEPARSE_FORHEAD_";  --五官分割-额头
DeviceResource.DEVICE_FACEPARSE_HEAD = "DEVICE_FACEPARSE_HEAD";
DeviceResource.DEVICE_DISNEYTRANSFER = "DISNEY_STYLE";  --Disney纹理

DeviceResource.DEVICE_DISNEYTRANSFERBK = "DISNEY_BK";  --Disney纹理

DeviceResource.DEVICE_AIFACETRANSFER = "AIFACE_STYLE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK = "AIFACE_BK";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER1 = "OLD_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK1 = "OLD_BG";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER2 = "KID_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK2 = "KID_BG";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER3 = "FEMALE_BEAUTY_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK3 = "FEMALE_BEAUTY_BG";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER4 = "MALE_BEAUTY_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK4 = "MALE_BEAUTY_BG";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER5 = "CG_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK5 = "CG_BG";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER6 = "BALD_FACE";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK6 = "BALD_GB";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER7 = "AIFACE_STYLE7";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK7 = "AIFACE_BK7";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER8 = "AIFACE_STYLE8";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK8 = "AIFACE_BK8";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER9 = "AIFACE_STYLE9";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK9 = "AIFACE_BK9";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER10 = "AIFACE_STYLE10";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK10 = "AIFACE_BK10";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER11 = "AIFACE_STYLE11";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK11 = "AIFACE_BK11";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER12 = "AIFACE_STYLE12";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK12 = "AIFACE_BK12";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER13 = "AIFACE_STYLE13";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK13 = "AIFACE_BK13";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER14 = "AIFACE_STYLE14";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK14 = "AIFACE_BK14";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFER15 = "AIFACE_STYLE15";  --AIFace纹理

DeviceResource.DEVICE_AIFACETRANSFERBK15 = "AIFACE_BK15";  --AIFace纹理

DeviceResource.DEVICE_PHOTOUPLOAD1 = "PHOTO_UPLOAD1";  --相册上传 感觉应该可以不用定义？...

DeviceResource.DEVICE_AIMORPH = "AIMORPH";  --Disney纹理

--设置一个系统提供的数据对象
function DeviceResource:PushDeviceResource(name, entity)
  local typename = entity:GetTypeName();
  if entity:isType(apollocore.TextureEntity:RTTI()) then
    local texfrom = apollocore.TextureEntity();
    texfrom:PushMetadata(apollocore.TextureReferenceMetadata(name));
    apollocore.IResourceSystem:RedirectResource(texfrom, entity);
    local reslist = self.ResourceList[typename] or {}
    local isExist = false;
    for k,v in ipairs(reslist) do
      if v == name then
        isExist = true;
      end
    end
    if not isExist then
      table.insert(reslist, name);
    end
    self.ResourceList[typename] = reslist;
  else
    error("unsupport resource type " .. typename);
  end  
end

--传入类型返回数据数组
function DeviceResource:GetDeviceResources(type_rtti)  
  local typename = type_rtti:GetTypeName();
  return self.ResourceList[typename];
end

return DeviceResource;
