

#DEFPARAMS
TEXTURE_BLOOM = { "TextureBloom", TEXTURE2D, "white" },
BLOOM_PARAM = { "BloomParam", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "SuperMeBloom"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BLOOM;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BLOOM_Sampler;
float BLOOM_PARAM;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 color : SV_Target0)
{
    float4 bloomColor = TEXTURE_BLOOM.Sample( TEXTURE_BLOOM_Sampler, i.uv);
    float4 bloomI;
    bloomI.xyz = bloomColor.xyz;

    float4 mainColor = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, i.uv );
    mainColor = max(mainColor, float4(0.0, 0.0, 0.0, 0.0) );
    bloomI.xyz = bloomI.xyz * float3(BLOOM_PARAM,BLOOM_PARAM,BLOOM_PARAM) + mainColor.xyz;

    color.w = mainColor.w;
    color.xyz = min(bloomI.xyz, float3(1.0, 1.0, 1.0));
}
ENDCG
#END
