#SHADER_DEFINE LaplaceVertex
	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
    { TARGETSIZE,         MEDIUM,   VEC2,     "in_TexSize"},

	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
		{ LAPLACE_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_LaplaceCoord", "9" },
	}

#SHADER_CODE
  vec2 out_TexCooridate = in_Coordinate.xy;
  gl_Position = in_Position;
  
  highp vec2 offset0=vec2(-1.0,-1.0); highp vec2 offset1=vec2(0.0,-1.0); highp vec2 offset2=vec2(1.0,-1.0);
	highp vec2 offset3=vec2(-1.0,0.0); highp vec2 offset4=vec2(0.0,0.0); highp vec2 offset5=vec2(1.0,0.0);
	highp vec2 offset6=vec2(-1.0,1.0); highp vec2 offset7=vec2(0.0,1.0); highp vec2 offset8=vec2(1.0,1.0);
  highp vec2 out_LaplaceCoord[9];
  out_LaplaceCoord[0] = in_Coordinate.st + offset0.xy/in_TexSize;
	out_LaplaceCoord[1] = in_Coordinate.st + offset1.xy/in_TexSize;
	out_LaplaceCoord[2] = in_Coordinate.st + offset2.xy/in_TexSize;
	out_LaplaceCoord[3] = in_Coordinate.st + offset3.xy/in_TexSize;
	out_LaplaceCoord[4] = in_Coordinate.st + offset4.xy/in_TexSize;
	out_LaplaceCoord[5] = in_Coordinate.st + offset5.xy/in_TexSize;
	out_LaplaceCoord[6] = in_Coordinate.st + offset6.xy/in_TexSize;
	out_LaplaceCoord[7] = in_Coordinate.st + offset7.xy/in_TexSize;
	out_LaplaceCoord[8] = in_Coordinate.st + offset8.xy/in_TexSize;
#END_CODE
#END_DEFINE



#SHADER_DEFINE LaplaceFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"in_DiffuseTexture" },
    { ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
    { SHARPEN_STRENGTH,         HIGH, FLOAT,      "in_SharpenStregth"},
    { LAPLACE_COORDNATE,  MEDIUM, VEC2_ARRAY,  "in_LaplaceCoord",  "9"},
	}
	FUNCTION_OUTPUT =
	{
	}
#SHADER_CODE
	highp float scaleFactor = in_SharpenStregth;
  
	highp float kernelValue0 = 0.0; highp float kernelValue1 = -1.0; highp float kernelValue2 = 0.0;
	highp float kernelValue3 = -1.0; highp float kernelValue4 = 4.0; highp float kernelValue5 = -1.0;
	highp float kernelValue6 = 0.0; highp float kernelValue7 = -1.0; highp float kernelValue8 = 0.0;

	highp vec4 cTemp0,cTemp1,cTemp2,cTemp3,cTemp4,cTemp5,cTemp6,cTemp7,cTemp8;
	cTemp0=texture2D(in_DiffuseTexture, in_LaplaceCoord[0]);
	cTemp1=texture2D(in_DiffuseTexture, in_LaplaceCoord[1]);
	cTemp2=texture2D(in_DiffuseTexture, in_LaplaceCoord[2]);
	cTemp3=texture2D(in_DiffuseTexture, in_LaplaceCoord[3]);
	cTemp4=texture2D(in_DiffuseTexture, in_LaplaceCoord[4]);
	cTemp5=texture2D(in_DiffuseTexture, in_LaplaceCoord[5]);
	cTemp6=texture2D(in_DiffuseTexture, in_LaplaceCoord[6]);
	cTemp7=texture2D(in_DiffuseTexture, in_LaplaceCoord[7]);
	cTemp8=texture2D(in_DiffuseTexture, in_LaplaceCoord[8]);

	highp vec4 sum = kernelValue0*cTemp0 + kernelValue1*cTemp1 + kernelValue2*cTemp2 +
		 kernelValue3*cTemp3 + kernelValue4*cTemp4 + kernelValue5*cTemp5+
	     kernelValue6*cTemp6 + kernelValue7*cTemp7 + kernelValue8*cTemp8;
       
  gl_FragColor = cTemp4 + sum * scaleFactor;
#END_CODE
#END_DEFINE