#SHADER_DEFINE HighpassVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  HighpassFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_ORIGIN,            NONE,      TEXTURE2D,   "in_OriginTexture"},
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
    }

#SHADER_CODE
    float intensity = 24.0;   // 强光程度
    vec4 sourceColor = texture2D(in_OriginTexture, vec2(in_TexCoordinate.x,in_TexCoordinate.y));
    vec4 blurColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    // 高通滤波之后的颜色值
    highp vec4 highPassColor = sourceColor - blurColor;
    // 强光模式
    highPassColor.r = clamp(2.0 * highPassColor.r * highPassColor.r * intensity, 0.0, 1.0);
    highPassColor.g = clamp(2.0 * highPassColor.g * highPassColor.g * intensity, 0.0, 1.0);
    highPassColor.b = clamp(2.0 * highPassColor.b * highPassColor.b * intensity, 0.0, 1.0);
    

    gl_FragColor = vec4(highPassColor.rgb, 1.0);
#END_CODE
#END_DEFINE







