#DEFPARAMS
_Intensity = { "reflection intensity", FLOAT, "0.5"},
#END
 
   
#DEFTAG
ShaderName = "Collect"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


Texture2D TEXTURE_GBUFFER_A;
Texture2D TEXTURE_GBUFFER_B;
Texture2D TEXTURE_MAINTEX;
//Texture2D TEXTURE_REFLECT;
Texture2D TEXTURE_REFLECT_BLUR;

SamplerState TEXTURE_GBUFFER_A_SAMPLER;
SamplerState TEXTURE_GBUFFER_B_SAMPLER;
SamplerState TEXTURE_MAINTEX_SAMPLER;
//SamplerState TEXTURE_REFLECT_SAMPLER;
SamplerState TEXTURE_REFLECT_BLUR_SAMPLER;

float _Intensity;

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	float2 uv = i.uv;
	//float metallic = TEXTURE_GBUFFER_A.Sample(TEXTURE_GBUFFER_A_SAMPLER, uv).w;
	float smoothness = TEXTURE_GBUFFER_B.Sample(TEXTURE_GBUFFER_B_SAMPLER, uv).w;
	outColor = TEXTURE_MAINTEX.Sample(TEXTURE_MAINTEX_SAMPLER, uv); 
	//float4 reflected = TEXTURE_REFLECT.Sample(TEXTURE_REFLECT_SAMPLER, uv).rgba;
	float4 reflectedBlur = TEXTURE_REFLECT_BLUR.Sample(TEXTURE_REFLECT_BLUR_SAMPLER, uv).rgba;
	outColor.rgb = lerp(outColor.rgb, reflectedBlur.rgb, min(reflectedBlur.a * smoothness * _Intensity, 1.0));
}

ENDCG
#END

