

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Combine_1"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_DIFFUSE2;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_DIFFUSE2_Sampler;
float2 TARGETSIZE;

float PRETHRESHOLD;
float THRESHOLD;
float SIGMA_R;
 
v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float tau=0.99;
    float sigma_e=1.0;
    float2 size = TARGETSIZE;
    float twoSigmaG1 = 2.0 * sigma_e * sigma_e;
    float twoSigmaG2 = 2.0 * SIGMA_R * SIGMA_R;
    float ancho = 2.0 * SIGMA_R;
    float2 uv = i.uv;
    float2 gradient = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv).zw;
    float2 dirPerpen = float2(gradient.y*2.0-1.0, -(gradient.x*2.0-1.0))/size;
    float2 acum = TEXTURE_DIFFUSE2.Sample( TEXTURE_DIFFUSE2_Sampler, uv ).xx;
    float2 norm = float2(1.0, 1.0);
    for( float i = 1.0; i <= ancho; i ++ )
    {
        float2 kernel = float2( exp( -i*i*i/ twoSigmaG1 ), exp( -i*i*i / twoSigmaG2 ));
        norm += 2.0* kernel;
        float local = TEXTURE_DIFFUSE2.Sample( TEXTURE_DIFFUSE2_Sampler, uv - i*dirPerpen ).x+TEXTURE_DIFFUSE2.Sample( TEXTURE_DIFFUSE2_Sampler, uv + i*dirPerpen ).x;
        acum += kernel*float2(local,local);
    }
    acum = acum/norm;
    float total = (300.0*PRETHRESHOLD) * (acum.x - tau * acum.y);
    mainColor = float4( (step (0.8, total ) ),gradient, 1.0);
}
ENDCG
#END
