
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "nl_reflection"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

uniform float3x3 LOCALWORLD_ROTATION;
Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_REFLECTION;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_REFLECTION_Sampler;
float UNIFORM_REFFACTOR;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = mul(v.normal, LOCALWORLD_ROTATION).xyz;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float3 viewDir = normalize(float3(i.worldpos.xyz) - CAMERA_WORLDPOSITION);
	float3 reflectDir = reflect(viewDir, normalize(i.worldnormal));
	reflectDir.xy = reflectDir.xy * float2(0.5, -0.5) + float2(0.5, 0.5);
	float4 color = TEXTURE_REFLECTION.Sample(TEXTURE_REFLECTION_Sampler, reflectDir.xy)*UNIFORM_REFFACTOR;
	color.a = 0.0;
	
  	float4 color2 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv)+color;
	mainColor = color2;
}
ENDCG
#END
