

#DEFPARAMS
#END

#DEFTAG
ShaderName = "AIMorph"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
// #include "utils.inc"

struct appdata   
{
	float3 vertex : POSITION;
	float2 uv1 : TEXCOORD0;
	float2 uv2 : TEXCOORD1;
	float2 uv3 : TEXCOORD2;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv1 : TEXCOORD0;
	float2 uv2 : TEXCOORD1;
	float2 uv3 : TEXCOORD3;
};

Texture2D TEXTURE_SRC;
Texture2D TEXTURE_DST;
Texture2D TEXTURE_GAN;
SamplerState TEXTURE_SRC_Sampler;
SamplerState TEXTURE_DST_Sampler;
SamplerState TEXTURE_GAN_Sampler;

float4x4 PARAMS;
float2 dstSize;
float2 srcSize;
float alpha;
v2f vert(appdata v)
{
	v2f o;
	o.vertex = float4(v.vertex,1.0);
	
    o.vertex.xy = float2((v.vertex.x)  * 2.0 - 1.0, (1-v.vertex.y ) * 2.0 - 1.0);

	o.vertex = UniformNDC(o.vertex);
	
	// o.uv1 = float2(v.uv1.x / dstSize.x, v.uv1.y / dstSize.y);
	// o.uv2 = float2(v.uv2.x / srcSize.x, v.uv2.y / srcSize.y);
	o.uv1 = float2(v.uv1.x , v.uv1.y );
	o.uv2 = float2(v.uv2.x , v.uv2.y );
	o.uv3 = float2(v.uv3.x , 1 - v.uv3.y );
	return o;
}


void frag(in v2f i, out float4 mainColor : SV_Target0)
{

    float4 dstColor = TEXTURE_DST.Sample(TEXTURE_DST_Sampler, i.uv1);
    float4 srcColor = TEXTURE_SRC.Sample(TEXTURE_SRC_Sampler, i.uv2);
    float4 ganColor = TEXTURE_GAN.Sample(TEXTURE_GAN_Sampler, i.uv3);
	float alphaface = ganColor.a;
	if(i.uv1.x > 1 || i.uv1.y > 1 || i.uv1.x < 0 || i.uv1.y < 0)
	{
		dstColor = float4(0, 0, 0, 1);
	}
	if(i.uv2.x > 1 || i.uv2.y > 1 || i.uv2.x < 0 || i.uv2.y < 0)
	{
		srcColor = float4(0, 0, 0, 1);
	}
	float4 finalDstColor = float4(dstColor.rgb * (1-alphaface) + ganColor.rgb * alphaface, 1);
    mainColor = float4(finalDstColor.rgb * alpha + srcColor.rgb * (1-alpha), 1);
    // return float4(dstColor.rgb * alpha + srcColor.rgb * (1-alpha), 1);
}
ENDCG
#END
