

#DEFPARAMS
_BGTex = { "BG Texture", TEXTURE2D, "white" },
_MaskTex = { "Mask Texture", TEXTURE2D, "white" },
_CutOff = { "CutOff", FLOAT, "0.2" },
_Color =  { "_Color", FLOAT, "3" },
#END

#DEFTAG
ShaderName = "avatardepthmask"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM   
#pragma vertex vert  
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
};

struct v2f
{ 
	float4 vertex : SV_POSITION;
    float4 outPos : TEXCOORD0;
};

Texture2D _BGTex;
Texture2D _MaskTex;

SamplerState _BGTexSampler;
SamplerState _MaskTexSampler;

float _CutOff;
float _Color;
v2f vert(appdata v)
{  
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
    float4 outpos = UniformNDC(pos);  
	o.vertex = outpos;
    o.outPos =  outpos;
	return o;
}
   
void frag(in v2f i, out float4 outColor : SV_Target0)    
{    
    float2 uv = i.outPos.xy/i.outPos.w;
    uv = (uv+float2(1.0,1.0))/2.0;

  #ifdef SHADER_TARGET_HLSL
		uv.y = 1.0-uv.y;
	#endif
	   
    float4 maskcolor =  _MaskTex.Sample(_MaskTexSampler,uv);
    outColor =  _BGTex.Sample(_BGTexSampler,uv);
  
    if (maskcolor[(int)_Color]<_CutOff) discard; 
    int a_index = (int)_Color;
    outColor.a = maskcolor[a_index];
}
ENDCG
#END
