

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "SkeletonAnimation"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainSampler;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	//这里需要放大100倍
	o.vertex = ObjectPos(v.vertex);
	o.uv = v.uv;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	// sample the texture
	mainColor = _MainTex.Sample(_MainSampler, i.uv);
}
ENDCG
#END
