local SequenceAnimation = require "apolloutility.sequenceanimation"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local Object = require "classic"
local PupilRender = require "pupil.pupilrender"
local pupildefined = require "pupil.pupildefined"
local PupilSequenceAnimation = require "pupil.pupilsequenceanimation"
require "venusdebug"


--瞳孔序列帧
local pupil = Object:extend();

function pupil:new(camera)
  self.maincamera = camera;
  self.left_pupil_sequenceanimation = PupilSequenceAnimation();
  self.right_pupil_sequenceanimation = PupilSequenceAnimation();
  self:SetShow(false);
end

function pupil:ParseConfig(config,pathDir)
  local res = true;
  if config ~= nil then
    local left_pupil = config.left;
    if left_pupil ~= nil then
      local texture_rgb = left_pupil.textures_rgb;
      local texture_alpha = left_pupil.textures_alpha;
      local fps = left_pupil.fps;
      local loop = left_pupil.loop;
      local beginIndex = left_pupil.begin or 1;
      local alphamode = left_pupil.alpha_mode or "normal";
      self.left_pupil_sequenceanimation:SetupMaterial(alphamode);
      renderqueue:Before(self.left_pupil_sequenceanimation);
      self.left_pupil_sequenceanimation:Play(pathDir, texture_rgb, texture_alpha, fps, loop, beginIndex);
    end
    local right_pupil = config.right;
    if right_pupil ~= nil then
      local texture_rgb = right_pupil.textures_rgb;
      local texture_alpha = right_pupil.textures_alpha;
      local fps = right_pupil.fps;
      local loop = right_pupil.loop;
      local beginIndex = right_pupil.begin or 1;
      local alphamode = right_pupil.alpha_mode or "normal";
      self.right_pupil_sequenceanimation:SetupMaterial(alphamode);
      renderqueue:Before(self.right_pupil_sequenceanimation);
      self.right_pupil_sequenceanimation:Play(pathDir, texture_rgb, texture_alpha, fps, loop, beginIndex);
    end
  end
  return res;
end


function pupil:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.left_pupil_sequenceanimation:SetShow(isShow);
    self.right_pupil_sequenceanimation:SetShow(isShow);
  end
end


function pupil:Update(timespan, left_pupil_points,right_pupil_points)
  --得到瞳孔点
  --local left_pupil_points;
  --local right_pupil_points;
  --left_pupil_points = pupilinfo:GetKeypointArray();
  
  --local testPointArray1 = {};
  --测试序列帧
  --[[
  table.insert(testPointArray1,{-0.125,0.125});
  table.insert(testPointArray1,{-0.125,-0.125});
  table.insert(testPointArray1,{0.125,-0.125});
  table.insert(testPointArray1,{0.125,0.125});
  table.insert(testPointArray1,{0,0});
]]--

  --for i = 53,58 do
  --  table.insert(testPointArray1,left_pupil_points[i]);
  --end
  --table.insert(testPointArray1,left_pupil_points[105]);
  
  --local testPointArray2 = {};
  --for i = 59,64 do
  --  table.insert(testPointArray2,left_pupil_points[i]);
  --end
  --table.insert(testPointArray2,left_pupil_points[106]);
  
  
  
  --right_pupil_points = pupilinfo:GetRightPupilPointArray();
  
  self.left_pupil_sequenceanimation:Update(timespan,left_pupil_points);
  self.right_pupil_sequenceanimation:Update(timespan,right_pupil_points);
end





return pupil;