local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local editorscene = require "editorscene"
local JointNode = require "apolloengine.nodes.jointnode"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"
local MemberIterator = require "venuscore.rtti.mpairs"


local editorscenemanager = {}

function editorscenemanager:Initialize(prevlayer,resourceType)
  self.scene = {};
  self.baseobjects = {};
  self.sceneIndex = 0;
  self.prevLayer = prevlayer;
  self.resourceType = resourceType;
  self.currentSceneIndex = 0;
end

function editorscenemanager:LoadConfig(path,insertLocation)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.scene then
    local lastTex = renderqueue:GetTexture("Input")
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_STICKER,
      lastTex);
    
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local metaconfig = venusjson.LaodJsonFile(rootconfig.scene..".meta");
    local AdvancedShadingSetting = false;
    if metaconfig and metaconfig.AdvancedShading == true then
          AdvancedShadingSetting = true;
    end

    -- set global color space settings before loading resources.    
    apollocore.Framework:SetCurrentAdvancedShading(AdvancedShadingSetting);
    local baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene));
    local layer = insertLocation or self.prevLayer;
    local newscene = editorscene(layer,self.resourceType);
    newscene.resourcePath = path;  --将素材路径记录下来
    newscene.isAdvanced = AdvancedShadingSetting;  --记录贴纸的色彩空间
    newscene:LoadConfig(baseobject);
    videodecet:Swicth2LinearSpace(AdvancedShadingSetting);
    -- recover global color space setting
    if AdvancedShadingSetting == true then
      apollocore.Framework:SetCurrentAdvancedShading(false);
    end
    self.sceneIndex = self.sceneIndex + 1;
    self.scene[self.sceneIndex] = newscene;
    self.baseobjects[self.sceneIndex] = baseobject;

    --renderqueue:Activate(self.prevLayer);
    lastTex = renderqueue:GetTexture(self.prevLayer);
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_STICKER,
      lastTex);
    
  end
  return true;
end

function editorscenemanager:UnloadConfig(path)
  for i=1, self.sceneIndex do
    if path == self.scene[i].resourcePath then
      self.scene[i]:ReleaseResource();
      table.remove(self.scene, i);
      table.remove(self.baseobjects, i);
      self.sceneIndex = self.sceneIndex - 1;
      break;
    end
  end
end

function editorscenemanager:UnloadConfig(path)
  for i=1, self.sceneIndex do
    if path == self.scene[i].resourcePath then
      self.scene[i]:ReleaseResource();
      table.remove(self.scene, i);
      table.remove(self.baseobjects, i);
      self.sceneIndex = self.sceneIndex - 1;
      break;
    end
  end
end

function editorscenemanager:GetSceneCount()
  return self.sceneIndex;
end

function editorscenemanager:LoadScene(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  local baseobject = nil;
  if rootconfig.scene then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene));
    self:DisableObjects(baseobject);
  end
  return baseobject;
end

function editorscenemanager:LoadSceneByFilePath(scenepath,rootdir)
  if scenepath then
    renderqueue:Activate(self.prevLayer);
    local lastTex = renderqueue:GetTexture(self.prevLayer);
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_STICKER,
      lastTex);
    
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(scenepath));
    local layer = insertLocation or self.prevLayer;
    local newscene = editorscene(layer,self.resourceType);
    newscene:LoadConfig(baseobject);
    self.sceneIndex = self.sceneIndex + 1;
    self.scene[self.sceneIndex] = newscene;
    self.baseobjects[self.sceneIndex] = baseobject;
    
  end
  return true;
end

function editorscenemanager:InitScene(baseobject,insertLayer,index,resourceType)
  local newscene = nil;
  local newsceneIndex = nil;
  local layer = insertLayer or self.prevLayer;
  if self.scene[index] ~= nil then
    newscene = self.scene[index];
    newsceneIndex = index;
  else
    newscene = editorscene(layer,self.resourceType);
    self.sceneIndex = self.sceneIndex + 1;
    self.scene[self.sceneIndex] = newscene;
    self.baseobjects[self.sceneIndex] = baseobject;
    newsceneIndex = self.sceneIndex;
  end
  self:EnableObjects(baseobject);
  newscene:LoadConfig(baseobject);
  newscene:Enable();
  --newscene.enable = true;
  self.currentSceneIndex = newsceneIndex;
  return newscene, newsceneIndex;
end

function editorscenemanager:EnableObjects(objects)
  for i = 1, #objects do
    local rendercom = objects[i]:GetComponent(apolloengine.Node.CT_RENDER)
    if rendercom then
      rendercom:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
    local cameracom = objects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
    if cameracom then
      cameracom:Activate();
    end
  end
end

function editorscenemanager:DisableObjects(objects)
  for i = 1, #objects do
    local rendercom = objects[i]:GetComponent(apolloengine.Node.CT_RENDER)
    if rendercom then
      rendercom:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
    local cameracom = objects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
    if cameracom then
      cameracom:Deactivate();
    end
  end
end

function editorscenemanager:DisableCurrentScene()
  if self.scene[self.currentSceneIndex] and self.baseobjects[self.currentSceneIndex] then
    self:DisableObjects(self.baseobjects[self.currentSceneIndex]);
    self.scene[self.currentSceneIndex]:RemoveCurrentSceneCameras();
    self.scene[self.currentSceneIndex]:Disable();
    --self.scene[self.currentSceneIndex].enable = false;
  end
end

function editorscenemanager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local str = venuscore.IFileSystem:ReadFile(path);
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);

  --Sene的属性最新反序列化都会自动反序列化回来，不需要再创建多余的场景了
  local _,deSerializeRes = BundleSystem:DeserializeFromPath(bundlepath,BundleSystem.DeserializeMode.Scene,scene);
  return deSerializeRes;
end

--LIJING:test
function editorscenemanager:CreateInstanceFromBundle2(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local file = io.open(bundlepath, "rb");
  local str = file:read("*a");
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  local res = BundleSystem:DeSerialize(str,scene,BundleSystem.DeserializeMode.Scene);
  local stickerNode = scene:CreateNode(apollocore.Node.CT_NODE);
  stickerNode:SetName("stickerNode"..(self.sceneIndex + 1));
  --TODO: 加进去
  for i = 1, #res do
    if res[i].GetNativeNode then
      stickerNode:AttachNode(res[i]:GetNativeNode());
    else
      stickerNode:AttachNode(res[i]);
    end
    
  end
  local component = stickerNode:CreateComponent(apollocore.Node.CT_TRANSFORM);
  component:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));
  return {stickerNode};
end

--LIJING:endtest



--重新加载素材
function editorscenemanager:OnRecordStart()
  --这里注册一个时间
end

function editorscenemanager:ReleaseResource()
   for i = 1, self.sceneIndex do
    self.scene[i]:ReleaseResource();
    self.scene[i] = nil;
    self.baseobjects[i] = nil;
   end
   local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
   scene:SetMainCamera(nil);
   apollocore.SceneManager.referenceinfos = {}; 
   self.sceneIndex = 0;
end

function editorscenemanager:Update(def)
  
  for k,v in pairs(self.scene) do 
    if v.enable then
      apollocore.Framework:SetCurrentAdvancedShading(v.AdvancedShading == true);
      v:Update(def)
    end
  end
  apollocore.Framework:SetCurrentAdvancedShading(false);
end

return editorscenemanager;
