local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local apolloDefine = require "apolloutility.defiend"
--local BlueDefined = require "bluecore.bluedefined"

local editorscene = Object:extend();

local PhysicsFreq = 150;

--resourceType: (hack parameter)标记加载的是那种类型的资源（滤镜/美妆/贴纸。。。）
function editorscene:new(insertlayer,resourceType, lastQueueName)
  self:Initialize()
  self.insertLayer = insertlayer;
  self.resourceType = resourceType;
  self.lastQueueName = lastQueueName;--may nil
end

function editorscene:Initialize()
  self.objects = {};
  
  self.lastCamera = {};
  self.firstCamera = {};
  self.sceneCamers = {};
  self.aniComponents = {};
  self.frameaniComponents = {};
  self.renderComponents = {};
  self.cpuEmitter = nil;
  
  self.inputtex = nil; --上层layer的结果
  self.outputtex = nil; -- 编辑器场景结果
  self.mainrt = nil; 
  self.firstquadnode = nil;
  self.rootNodeKeys = {};
  self.resourcePath = nil;
  
  self.index = nil;
  
  self.mainOutputCamera = {};
  
  self.enable = true;

  self.srgb2normal_rt = nil;
  self.srgb2normal_camera = nil;
  self.srgb2normal_quad = nil;

  --self.objectUsrscripts = {};
end

function editorscene:Update(def)
  
  --[[for key, value in pairs(self.objectUsrscripts) do
    value:Update(def);
  end]]--
  
  --纹理需要每帧设置，renderqueue中删除插入相机时纹理会变
  if self.firstquadnode then
    self.firstquadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.inputtex);
  end
  
  for key, value in ipairs(self.rootNodeKeys) do
    local rootNode = self.objects[value];
    if rootNode.GetNativeNode then
      rootNode = rootNode:GetNativeNode();
    end
    if not venuscore.isNil(rootNode) then
      self:_OnUpdate(rootNode,def);
      self:_OnLateUpdate(rootNode,def);
    end
  end

  
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  local physicWorld = scene:GetPhysicWorld();
    
  physicWorld:Update(def, 10, 1/300);
  physicWorld:UpdateKinematics(0.2, 5);


  --self:_OnUpdate(self.objects[1], def);
end

function editorscene:UpdateWithOutPhysic(def)
  --纹理需要每帧设置，renderqueue中删除插入相机时纹理会变
  if self.firstquadnode then
    self.firstquadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.inputtex);
  end
  
  for key, value in ipairs(self.rootNodeKeys) do
    local rootNode = self.objects[value];
    if rootNode.GetNativeNode then
      rootNode = rootNode:GetNativeNode();
    end
    if not venuscore.isNil(rootNode) then
      self:_OnUpdate(rootNode,def);
      self:_OnLateUpdate(rootNode,def);
    end
  end
end

function editorscene:_OnUpdate(node,def)
  if not venuscore.isNil(node) and node.isActiveHierarchy and node:isActiveHierarchy() == true then
    if node.Update then
      node:Update(def)
    end
    local subNodes = node:GetChildrens();
    for k,v in pairs(subNodes) do
      self:_OnUpdate(v, def);
    end
  end
  

end


function editorscene:_OnLateUpdate(node,def)
  if node.isActiveHierarchy and node:isActiveHierarchy() == true then
    if node.Update then
      node:LateUpdate(def)
    end
    local subNodes = node:GetChildrens();
    for k,v in pairs(subNodes) do
      self:_OnLateUpdate(v, def);
    end
  end
end

function editorscene:LoadConfig(baseobject, mainrt)
    for i = 1, #baseobject do
      local nativeNode = baseobject[i];
      if nativeNode.GetNativeNode then
        nativeNode = baseobject[i]:GetNativeNode();
      end
      
      local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
      local sceneRoot = scene:GetRootNode();
      
      local nodeRoot = nativeNode:GetRoot();
      if nodeRoot and nodeRoot:GetObjectID() == sceneRoot:GetObjectID() then
        table.insert(self.rootNodeKeys,nativeNode:GetObjectID());
      end
      local nodeType = baseobject[i]:GetTypeName();
      self.objects[tostring(nativeNode:GetObjectID())] = baseobject[i];
      
      if nodeType == "ParticleNode" then
        local rendercom = baseobject[i].RenerComponent;
        if rendercom then
          self.renderComponents[tostring(nativeNode.Layer)] = self.renderComponents[tostring(nativeNode.Layer)] or {};
          table.insert(self.renderComponents[tostring(nativeNode.Layer)],rendercom);
        end
        self.cpuEmitter = nativeNode;
      else
        local cameracom = baseobject[i]:GetComponent(apolloengine.Node.CT_CAMERA);
        if cameracom then
          cameracom:SetResourceType(self.resourceType);
          --找到所有的first camera
          if #self.firstCamera == 0 then
            table.insert(self.firstCamera,cameracom);
          elseif (self.firstCamera[1]).Sequence > cameracom.Sequence then
            self.firstCamera = {};
            table.insert(self.firstCamera,cameracom);
          elseif (self.firstCamera[1]).Sequence == cameracom.Sequence then
            table.insert(self.firstCamera,cameracom);
          end
          
          --找到所有的last camera
          if #self.lastCamera == 0 then
            table.insert(self.lastCamera,cameracom);
          elseif (self.lastCamera[1]).Sequence < cameracom.Sequence then
            self.lastCamera = {};
            table.insert(self.lastCamera,cameracom);
          elseif (self.lastCamera[1]).Sequence == cameracom.Sequence then
            table.insert(self.lastCamera,cameracom);
          end
          table.insert(self.sceneCamers,cameracom); --将相机保存起来
        end
        
        local rendercom = baseobject[i]:GetComponent(apolloengine.Node.CT_RENDER)
        if rendercom then
          rendercom:SetResourceType(self.resourceType);
          table.insert(self.renderComponents,rendercom);
        end
        
        local trailscom = baseobject[i]:GetComponent(apolloengine.Node.CT_TRAILSRENDER)
        if trailscom then
          trailscom:SetResourceType(self.resourceType);
          table.insert(self.renderComponents,trailscom);
        end

        local licom = baseobject[i]:GetComponent(apolloengine.Node.CT_LIGHT)
        if licom then
          licom:SetResourceType(self.resourceType);
        end

        local frameanicom = baseobject[i]:GetComponent(apolloengine.Node.CT_FRAME_PLAYER)
        if frameanicom then
          table.insert(self.frameaniComponents,frameanicom);
        end
        
        local animationcom = baseobject[i]:GetComponent(apolloengine.Node.CT_ANIMATION)
        if animationcom then
          table.insert(self.aniComponents,animationcom);
        end
        
        --找到蓝图Instance
        --local scriptComponent = baseobject[i]:GetComponent(apolloengine.Node.CT_BLUEPRINT);
        --if scriptComponent then
        --  local scriptInsList = scriptComponent.Instances;
        --  for key,value in pairs(scriptInsList) do
        --    if key == BlueDefined.LuaPath then
        --      --将素材路径记录到蓝图Script中
        --      value.ResourcePath = self.resourcePath;
        --    end
        --  end
        --end
      end
    end
    if #self.sceneCamers > 0 then
      self:_CameraInit(mainrt);
    end
  return true;
end

function editorscene:GetFirstCamera()
  for _, cam in ipairs(self.firstCamera) do
    if cam then
      if cam:isActiveHierarchy() then
        return cam;
      end
    end
  end
  return nil;
end

function editorscene:GetLastCamera()
  for _, cam in ipairs(self.lastCamera) do
    if cam then
      if cam:isActiveHierarchy() then
        return cam;
      end
    end
  end
  return nil;
end

function editorscene:GetFirstNode()
  return self.firstquadnode
end


function editorscene:GetInputTexture()
  return self.inputtex;
end

function editorscene:GetOutputTexture()
  return self.outputtex;
end

function editorscene:Enable()
  self.enable = true;
  self.firstquadnode:SetShow(true);
end

function editorscene:Disable()
  self.enable = false;
  self.firstquadnode:SetShow(false);
end

function editorscene:SetupSrgbCamAndRT(clearcolor, sequence)

  if self.srgb2normal_camera==nil then
    self.srgb2normal_camera = apollonode.CameraNode();--新建摄像机
    self.srgb2normal_camera:Activate();
    self.srgb2normal_camera:ChangeResolution(apolloengine.Framework:GetResolution());
    self.srgb2normal_camera:SetSequence(sequence);
    self.srgb2normal_camera:SetClearColor(clearcolor);
    self.srgb2normal_camera:SetLayerMaskNothing();
    self.srgb2normal_camera:SetSequenceCulling(false);
    self.srgb2normal_camera:AddLayerMask("EditorSceneSrgb2NormalMask");
  end
  
  if self.srgb2normal_rt == nil then
    self.srgb2normal_rt = apolloengine.RenderTargetEntity();--创建一个FBO
    self.srgb2normal_rt:PushMetadata(--设置FBO格式
                apolloengine.RenderTargetMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--标记作用，主要用于底层资源共享
                  apolloengine.Framework:GetViewport(),
                  apolloengine.Framework:GetResolution()));--分辨率
    local depth = self.srgb2normal_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
    depth:PushMetadata(
      apolloengine.DepthRenderBufferMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution(),
        apolloengine.TextureEntity.PF_DEPTH24_STENCIL8
      ));
    self.srgbOutputTex = self.srgb2normal_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    self.srgbOutputTex:PushMetadata(--创建纹理
                apolloengine.TextureRenderMetadata(
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
                  apolloengine.Framework:GetResolution(),
                  false));
    self.srgb2normal_rt:CreateResource();
    
    self.srgb2normal_camera:AttachRenderTarget(self.srgb2normal_rt)
  end

  if self.srgb2normal_quad == nil then
  local quadnode = apollonode.QuadNode();
    quadnode:SetShow(true);
    quadnode:CreateResource("comm:documents/material/lineartogamma.material", true);
    quadnode:SetLayer("EditorSceneSrgb2NormalMask");
    self.srgb2normal_quad = quadnode;
  end

  self.srgb2normal_quad:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.outputtex);
end

function editorscene:_CameraInit(mainrt)
  local color = mathfunction.Color(1.0,0.5,0.5,1);
  if mainrt == nil then
    self.mainrt =  apolloengine.RenderTargetEntity();--创建一个FBO
    self.mainrt:PushMetadata(--设置FBO格式
                apolloengine.RenderTargetMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--标记作用，主要用于底层资源共享
                  apolloengine.Framework:GetViewport(),
                  apolloengine.Framework:GetResolution()));--分辨率
    local depth = self.mainrt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
    depth:PushMetadata(
      apolloengine.DepthRenderBufferMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution(),
        apolloengine.TextureEntity.PF_DEPTH24_STENCIL8
      ));

    self.outputtex = self.mainrt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    self.outputtex:PushMetadata(--创建纹理
                apolloengine.TextureRenderMetadata(
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
                  apolloengine.Framework:GetResolution()));
    self.mainrt:CreateResource();
  else
    self.mainrt = mainrt;
    self.outputtex = mainrt:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0)
  end

  --没有fbo的相机
  --可能有多个主相机
  local maxSequence = -20000;
  local inputcameras = {};
  for i = 1, #self.sceneCamers do
    local cameraCom = self.sceneCamers[i];
    if cameraCom:GetAttachedRenderTarget() == nil then
      cameraCom:SetClearColor(color);
      cameraCom:AttachRenderTarget(self.mainrt);
      table.insert(self.mainOutputCamera,cameraCom); --保存编辑器相机做种的输出相机
    end
    maxSequence = math.max(cameraCom.Sequence);
    table.insert(inputcameras,cameraCom);
  end

  --[[
  for layer, camList in pairs(self.sceneCamers) do
    if camList then
      for _, cam in ipairs(camList) do
        if cam:GetAttachedRenderTarget() == nil then
          cam:SetClearColor(color);
          cam:AttachRenderTarget(self.mainrt);
          table.insert(self.mainOutputCamera,cam); 
        end
        table.insert(inputcameras,cam);
      end
    end
  end
  --]]
  --回调函数
  self.SettingInputTexture = function(texture)
    self.inputtex = texture;
  end
  
  self.GettingOutputTexture = function()
    local outtex = self.outputtex
    return outtex;
  end

  self.GettingSRGBOutputTexture = function()
    local outtex = self.srgbOutputTex
    return outtex;
  end
  
  self.OnSequenceChanged = function()
    --不需要再设置Sequence了，由Layer和Editor标记来做Culling
    --self:_RenderInit();  --renderqueue中删除相机的时候需要更新相机的sequence
    self.firstquadnode:SetName("Editor_Quad_Blit "..tostring(sequnce));
    self.firstquadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.inputtex);

    if self.lastQueueName ~= nil then
      apolloengine.DeviceResource:PushDeviceResource(
        self.lastQueueName, --apolloDefine.LAST_QUEUE_TEXTURE_EDITORMAKEUP,
        self.inputtex);
    end
  end
  
  self.firstquadnode = apollonode.QuadNode();
  self.firstquadnode:CreateResource(defined.blit_material_path,true,false);
  --关闭quad的裁剪
  self.firstquadnode:SetCull(false);
  self.firstquadnode:SetResourceType(self.resourceType);   --设置为只有编辑器绘制
  
  renderqueue:Activate(self.insertLayer);
  --编辑器相机队列插入renderqueue相机队列
  if apolloengine.Framework:IsCurrentAdvancedShading() then
    self:SetupSrgbCamAndRT(color, maxSequence + 100);
    self.index = renderqueue:InsertCameras(self.insertLayer,inputcameras,self.SettingInputTexture,self.GettingSRGBOutputTexture,self.OnSequenceChanged);
  else
    self.index = renderqueue:InsertCameras(self.insertLayer,inputcameras,self.SettingInputTexture,self.GettingOutputTexture,self.OnSequenceChanged);
  end

end

function editorscene:_RenderInit()
  for key,value in pairs (self.renderComponents) do
    local layerCameraList = self.sceneCamers[key];
    if layerCameraList then
      local cam = layerCameraList[1];
      if cam then
        local newsequence = cam.Sequence;
        for subkey, subvalue in pairs(value) do
          subvalue:SetSequence(newsequence);
        end
      end
    else
      ERROR("LAYER: " .. key .. " FOUND NO CAMERA");
    end
  end
end

function editorscene:_FramAniInit()
  for key,value in pairs (self.frameaniComponents) do
    value:Play();
  end
end

function editorscene:_ParticleInit()
  if self.cpuEmitter then
    self.cpuEmitter:Start();
  end
end

function editorscene:_AnimationInit()
    for key,value in pairs(self.aniComponents) do
      local animations = value:GetAnimations();
      for k,v in pairs(animations) do
        value:Play(k); 
        value:Loop(k,true);
      end
    end
end

function editorscene:SetMakeupStrength(strength, maketype)
  for k,v in pairs(self.objects) do 
    if v.Update and v.GetNativeNode then
      local node = v:GetNativeNode();
      local scriptCom = node:GetComponent(apolloengine.Node.CT_SCRIPT);
      if scriptCom then
        local paraSet = scriptCom.Instances
        for scrKey,scrValue in pairs(paraSet) do
          if scrValue["alphaTable"] ~= nil then
            scrValue:RecursiveNode(scrValue["Node"], strength);
            return true;
          end
        end
      end
    end
    local renderComponent = v:GetComponent(apolloengine.Node.CT_RENDER)
    if renderComponent then
      renderComponent:SetParameter("_Strength", mathfunction.vector1(strength))
    end
  end
end

function editorscene:GetMakeupStrength(type)
  for key, node in pairs(self.objects) do
    local renderComponent = node:GetComponent(apolloengine.Node.CT_RENDER)
    if renderComponent then
      local materials = renderComponent:GetMaterialEntities()
      if #materials > 0 then
        local material = materials[1]
        local vec = material:GetParameter("_Strength")
        if vec ~= nil and vec.x ~= nil then
          return vec:x()
        end
      end
    end
  end
end

function editorscene:SetFaceBeautyStrength(beauty_type, strength)
    for key, value in pairs(self.objects) do
        local scriptCom = value:GetComponent(apolloengine.Node.CT_SCRIPT);
        if scriptCom then
            local paraSet = scriptCom.Instances;
            for scrKey,scrValue in pairs(paraSet) do
                if scrValue["SetBeautyStrength"] ~= nil then
                    return scrValue:SetBeautyStrength(beauty_type, strength);
                end
            end
        end
    end
    return false;
end

function editorscene:ReleaseResource()
  
  --先把RT Detach掉
  for key, value in ipairs(self.mainOutputCamera) do
    LOG("Detach Main RenderTarget");
    value:DetachRenderTarget(self.mainrt);
  end

  if self.srgb2normal_camera and self.srgb2normal_rt then
    self.srgb2normal_camera:DetachRenderTarget(self.srgb2normal_rt);
    self.srgb2normal_camera:Destroy();
    self.srgb2normal_quad:Destroy();
  end
  self.srgb2normal_camera = nil;
  self.srgb2normal_rt = nil;
  self.srgb2normal_quad = nil;
  
  --只删除根节点
  for key, value in ipairs(self.rootNodeKeys) do
    local rootNode = self.objects[value];
    if rootNode.GetNativeNode then
      rootNode = rootNode:GetNativeNode();
    end
    if not venuscore.isNil(rootNode) then
      local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
      scene:DeleteNode(rootNode);  
    end
  end
  --删除firstNode
  if self.firstquadnode then
    self.firstquadnode:Destroy();
    self.firstquadnode = nil;
  end
  
  
  self.objects = {};
  self.firstCamera = {};
  self.lastCamera = {};
  self.sceneCamers = {};
  self.aniComponents = {};
  self.frameaniComponents = {};
  self.renderComponents = {};
  self.cpuEmitter = nil;
  
  self.outputtex =  nil;
  self.inputtex = nil;
  self.mainrt = nil;
  
  self.SettingInputTexture = nil;
  self.GettingOutputTexture = nil;
  
  self.mainOutputCamera = nil;
  
  if self.index then
    renderqueue:RemoveCameras(self.index);
  end
  
  
  collectgarbage();
end

function editorscene:RemoveCurrentSceneCameras()
  renderqueue:RemoveCameras(self.index);
  self.index = nil;
  --将之前场景中输出相机上挂在的RT移除掉
  if self.mainOutputCamera then
    for _, mainCam in ipairs(self.mainOutputCamera) do
      mainCam:DetachRenderTarget(self.mainrt);
    end
  end

  --self.mainOutputCamera:DetachRenderTarget(self.mainrt);
end

function editorscene:OnRecordStart()
  if not self.frameaniComponents or not self.aniComponents then
    return
  end
  
  for key,value in pairs (self.frameaniComponents) do
    value:Reset();
  end
  
  for key,value in pairs(self.aniComponents) do
    local animations = value:GetAnimations();
    for k,v in pairs(animations) do
      value:Reset(k); 
    end
  end
  
  if self.cpuEmitter then
    self.cpuEmitter:Reset();
  end
end


return editorscene;
