local venuscore     = require "venuscore"
local venusjson     = require "venusjson"
local encoder       = require "cartoon.encoder"
local request       = (require "socket.http").request
local sleep         = (require "socket").sleep

local web = {}

function web:Initialize(host, port)

  local res = false
  if host ~= nil and
     port ~= nil
  then
    self.server = host
    self.port = port
    res = true
  end
  
  return res;
end

function web:SendImage(image_path)
  local res, detail = web:_ConnectServer(image_path, self.server, self.port)
  return res, detail
end

function web:_ConnectServer(image_path, host, port)
  local res_post, msg = self:_UploadImage(image_path, host, port)
  
  if (not res_post) then
    return false
  end
  
  -- for the success one, msg is the same as task_id
  local res_get, detail = self:_GetExecResult(host, port, msg)
  
  return res_get, detail;
end

-- return code, reponse table
-- may need to spawn error to UI to display
function web:_UploadImage(image_path, host, port)
  local full_path = venuscore.IFileSystem:PathAssembly(image_path)
  
  local boundary = encoder.gen_boundary();
  local src, len = encoder.encode("file", full_path, boundary)
   
  local resp = {}
  local body, code, resp_header = request{
    url = "http://"..host..":"..port.."/v0/tasks",
    method = "POST",
    source = src,
    headers = {
        ["content-length"] = len,
        ["content-type"] = "multipart/form-data; boundary="..boundary
        
      },
      source = encoder.encode("file", full_path, boundary),
      sink = ltn12.sink.table(resp)
    }
    
  local err_str = nil;
  if (code ~= 200 and code ~= 400 and code ~= 503) then
    err_str = "Unknown exception. Code not expected."
    goto error
  end
      
  if resp_header["content-type"] ~= "application/json" or (#resp ~= 1) then
    err_str = "Unknown exception. Response content not expected."
    goto error
  end

  do
    local resp_tbl = venusjson.LoadJsonString(resp[1])
    if (code == 400 or code == 503) then
      err_str = "Error: "..resp_tbl.task_id
      goto error
    else
      LOG(resp_tbl.task_id)
      return true, resp_tbl.task_id
    end
  end
  
  ::error::
  LOG(err_str)
  return false, err_str
end


function web:_GetExecResult(host, port, task_id)
  local err_str = nil;
  
  while(true) do
    sleep(0.2)
    
    local resp = {}
    local body, code, resp_header = request{
      url = "http://"..host..":"..port.."/v0/tasks?task_id="..task_id,
      method = "GET",
      sink = ltn12.sink.table(resp)
    }
    
    if (code ~= 200 and code ~= 404) then
      err_str = "Unknown exception. Code not expected."
      goto error
    end
    if resp_header["content-type"] ~= "application/json" or (resp == nil)then
      err_str = "Unknown exception. Response content not expected."
      goto error
    end
    
    do
      local resp_msg = table.concat(resp)
      local resp_tbl = venusjson.LoadJsonString(resp_msg)
      if (code == 404) then
        err_str = "Error: "..resp_tbl.msg
        goto error
      else
        if (string.match(resp_tbl.status,"processed")) then
            LOG("Succeed!")
            return true, resp_tbl.result
        end
      end
    end
  end
  
  ::error::
  LOG(err_str)
  return false, err_str
end

return web
