local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local TestFriction = venuscore.VenusBehavior:extend("TestFriction");

function TestFriction:new()
	self.direction = 1;
	self.horizontalMove = false;
	self.verticalMove = false;
	self.positionSum = 0.0;
end

function TestFriction:_Play()

end

function TestFriction:_OnAwake()

end

function TestFriction:_OnStart()
  
end

function TestFriction:_OnUpdate(timespan)
	local num = 0;
	local transform = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
	if self.horizontalMove then
      local position = transform:GetLocalPosition();
	  local deltaPosition = self.direction * timespan;
	  self.positionSum = self.positionSum + timespan;
	  transform:SetLocalPosition(position + mathfunction.vector3(deltaPosition, 0.0, 0.0));
	  num = num + 1;
    end
    if self.verticalMove then
	  local position = transform:GetLocalPosition();
	  local deltaPosition = self.direction * timespan;
	  self.positionSum = self.positionSum + timespan;
	  transform:SetLocalPosition(position + mathfunction.vector3(0.0, deltaPosition, 0.0));
	  num = num + 1;
    end
    if self.positionSum > num * 0.3 then
      self.direction = self.direction * (-1);
      self.positionSum = 0;
    end
end

TestFriction:MemberRegister("horizontalMove");
TestFriction:MemberRegister("verticalMove");
return TestFriction
