--@author      : Jin Shiyu
--@date        : 2020-08-24
--@description : lua script for face beauty beahavior
--@version     : 1.0

local apolloengine  = require "apolloengine"
local mathfunction  = require "mathfunction"
local venuscore     = require "venuscore"
local defined       = require "apolloutility.defiend"
local quad_render   = require "facebeautyutils.face_beauty_quad_render"
local face_defined  = require "facebeautyutils.defined"
local face_beauty   = require "facebeautyutils.face_beauty"
local cv            = require "computervisionfunction"

--[[
    Face beauty on one frame, including brighten eye, nasolabial removal, eyebag removal and whiten teeth
    NOTE:
    the correspoding scene structure is:
    - node with [main camera, script and recognition] components
]]

local FaceBeautyBehavior = venuscore.VenusBehavior:extend("FaceBeautyBehavior");

local BRIGHT_EYE   = 1;
local NASOLABIAL   = 2;
local EYEBAG       = 3;
local WHITEN_TEETH = 4;

function FaceBeautyBehavior:new()
    self.CameraInput = nil;
    self.initialized = false;
end

function FaceBeautyBehavior:_OnStart()
    self:Initialize();
end

function FaceBeautyBehavior:_OnDestroy()
    face_beauty:Destroy();
end

function FaceBeautyBehavior:Initialize()

    local camera = self.Node:GetComponent(apolloengine.Node.CT_CAMERA);
    if camera == nil then
        return;
    end

    face_beauty:Create(camera:GetSequence());

    self.CameraInput = apolloengine.TextureEntity();
    self.CameraInput:PushMetadata(apolloengine.TextureReferenceMetadata(defined.LAST_QUEUE_TEXTURE));
    self.CameraInput:CreateResource();

    self.initialized = true;
end

function FaceBeautyBehavior:_OnUpdate()
    if not self.initialized then
        LOG("[FaceBeautyBehavior] not initialized");
        return;
    end

    -- always set show false before update render data
    local valid = face_beauty:PreUpdate();
    if not valid then
        LOG("[FaceBeautyBehavior] no need to render");
        return;
    end

    local camera = self.Node:GetComponent(apolloengine.Node.CT_CAMERA);
    if camera == nil then
        LOG("[FaceBeautyBehavior] camera is nil");
        return;
    end

    face_beauty:Update(camera:GetSequence(), self.CameraInput);
end

--编辑器回调属性Get、Set
function FaceBeautyBehavior:GetMaskTexturePath()
  return face_beauty:GetMaskTexturePath();
end

function FaceBeautyBehavior:SetMaskTexturePath(value)
  face_beauty:SetMaskTexturePath(value);
end

function FaceBeautyBehavior:GetTeethLookupTexturePath()
  return face_beauty:GetTeethLookupTexturePath();
end

function FaceBeautyBehavior:SetTeethLookupTexturePath(value)
  face_beauty:SetTeethLookupTexturePath(value);
end

function FaceBeautyBehavior:GetEyeMaskTexturePath()
  return face_beauty:GetEyeMaskTexturePath();
end

function FaceBeautyBehavior:SetEyeMaskTexturePath(value)
  face_beauty:SetEyeMaskTexturePath(value);
end

function FaceBeautyBehavior:GetBrightEyeStrength()
  return face_beauty:GetBeautyStrength(BRIGHT_EYE);
end

function FaceBeautyBehavior:SetBrightEyeStrength(value)
    face_beauty:SetBeautyStrength(BRIGHT_EYE, value);
end

function FaceBeautyBehavior:GetNasolabialStrength()
  return face_beauty:GetBeautyStrength(NASOLABIAL);
end

function FaceBeautyBehavior:SetNasolabialStrength(value)
    face_beauty:SetBeautyStrength(NASOLABIAL, value);
end

function FaceBeautyBehavior:GetEyeBagStrength()
  return face_beauty:GetBeautyStrength(EYEBAG);
end

function FaceBeautyBehavior:SetEyeBagStrength(value)
  face_beauty:SetBeautyStrength(EYEBAG, value);
end

function FaceBeautyBehavior:GetWhitenTeethStrength()
  return face_beauty:GetBeautyStrength(WHITEN_TEETH);
end

function FaceBeautyBehavior:SetWhitenTeethStrength(value)
  face_beauty:SetBeautyStrength(WHITEN_TEETH, value);
end

FaceBeautyBehavior:MemberRegister("mask_texture_path",
  venuscore.ScriptTypes.FilePathType(
    apolloengine.TextureEntity:RTTI(),
    FaceBeautyBehavior.GetMaskTexturePath,
    FaceBeautyBehavior.SetMaskTexturePath
));

FaceBeautyBehavior:MemberRegister("teeth_lookup_texture_path",
  venuscore.ScriptTypes.FilePathType(
    apolloengine.TextureEntity:RTTI(),
    FaceBeautyBehavior.GetTeethLookupTexturePath,
    FaceBeautyBehavior.SetTeethLookupTexturePath
));

FaceBeautyBehavior:MemberRegister("eye_mask_texture_path",
  venuscore.ScriptTypes.FilePathType(
    apolloengine.TextureEntity:RTTI(),
    FaceBeautyBehavior.GetEyeMaskTexturePath,
    FaceBeautyBehavior.SetEyeMaskTexturePath
));

FaceBeautyBehavior:MemberRegister("bright_eye_strength",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    FaceBeautyBehavior.GetBrightEyeStrength,
    FaceBeautyBehavior.SetBrightEyeStrength
));

FaceBeautyBehavior:MemberRegister("nasolabial_strength",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    FaceBeautyBehavior.GetNasolabialStrength,
    FaceBeautyBehavior.SetNasolabialStrength
));

FaceBeautyBehavior:MemberRegister("eyebag_strength",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    FaceBeautyBehavior.GetEyeBagStrength,
    FaceBeautyBehavior.SetEyeBagStrength
));

FaceBeautyBehavior:MemberRegister("whiten_teeth_strength",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    FaceBeautyBehavior.GetWhitenTeethStrength,
    FaceBeautyBehavior.SetWhitenTeethStrength
));

return FaceBeautyBehavior;