local venuscore = require "venuscore"
local venusjson     = require "venusjson"
local apolloengine = require "apolloengine"
local utils = require "behavior.cartoon_behavior.utils"

local MorpherControlBehavior = venuscore.VenusBehavior:extend("MorpherControlBehavior")
local ANIMATION_SCRIPT = "expression_animation_play_behavior.lua"

function MorpherControlBehavior:new()
  self.BsLookUp = ""
end

function MorpherControlBehavior:_OnAwake()
  if self.Morpher == nil then
    self.Morpher = self.Node:GetComponent(apolloengine.Node.CT_MORPH)
    if self.Morpher == nil then
      return
    end
    self:GetMorpherGroups()
  end
  
  if self.BsLookUp ~= "" then
    self:LoadBsLookUp()
  end
  if self.Animation ~= nil then
    self:RegisterNode()
  end
end

function MorpherControlBehavior:_OnUpdate(delta)
end

function MorpherControlBehavior:RegisterNode()
  local animation_behavior = utils:GetBehavior(self.Animation, ANIMATION_SCRIPT)
  if animation_behavior ~= nil then
    animation_behavior:RegisterMorpher(self.Node)
  end
end

function MorpherControlBehavior:Play(tracker_weight)
  if self.Morpher == nil then
      return
    end
  local group_index = self.Group - 1
  if self.bs_map == nil then
    for key, weight in pairs(tracker_weight) do
      self:UpdateWeight(group_index, key, weight)
    end
  else
    for key, name in pairs(self.bs_map) do
      local weight = tracker_weight[name]
      if weight ~= nil then
        self:UpdateWeight(group_index, key, weight)
      end
    end
  end
end

function MorpherControlBehavior:UpdateWeight(group_index, key, weight)
  local channel_index = self.Morpher:GetChannelIndexByName(group_index, key)
  if channel_index ~= -1 then
    self.Morpher:SetChannelPercents(group_index, channel_index, weight)
  end
end

function MorpherControlBehavior:GetMorpherGroups()
  if self.Morpher == nil then
    return {}
  end
  if self.groups ~= nil then
    return self.groups
  end
  
  self.groups = {}
  local group_num = self.Morpher:GetNumberOfGroup()
  for i = 0, group_num-1 do
    local group_name = self.Morpher:GetGroupName(i)
    table.insert(self.groups, group_name)
  end
  
  return self.groups  
end

function MorpherControlBehavior:SetBsLookUp(value)
  self.BsLookUp = value
  self:LoadBsLookUp()
end

function MorpherControlBehavior:GetBsLookUp()
  return self.BsLookUp
end

function MorpherControlBehavior:LoadBsLookUp()
  local rootconfig = venusjson.LaodJsonFile(self.BsLookUp)
  self.bs_map = rootconfig
end

MorpherControlBehavior:MemberRegister(
  "Animation",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),    
    nil,
    function(thiz, value)
      thiz.Animation = value
      thiz:RegisterNode()
    end
  )
)

MorpherControlBehavior:MemberRegister(
  "Morpher",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.MorpherComponent:RTTI(),    
    nil,
    function(thiz, value)
        thiz.Morpher = value
        thiz:GetMorpherGroups()
    end
  )
)

MorpherControlBehavior:MemberRegister("Group",  
  venuscore.ScriptTypes.ComboType(
    function(thiz)
      local result = {}
      local groups = thiz:GetMorpherGroups()
      for i = 1, #groups do
        table.insert(
          result,
          {
            key = groups[i],
            value = i
          }
        )
      end
      return result
    end
  )
)

MorpherControlBehavior:MemberRegister("BsLookUp",  
  venuscore.ScriptTypes.FilePathType(
    {"json"},
    MorpherControlBehavior.GetBsLookUp,
    MorpherControlBehavior.SetBsLookUp))

return MorpherControlBehavior