require "venusdebug"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local beautydefined
local beautyutils = require "beauty.utils"
local Len = require "beauty.len"

local ChinScale = {}

function ChinScale:_Bbox(config, keypoints, bboxData)
	for i = 1, #beautydefined.ChinKey do
    if type(beautydefined.ChinKey[i]) == "table" then
      local index1 = beautydefined.ChinKey[i][1] + 1;
      local index2 = beautydefined.ChinDir[i][2] + 1;
      local dr = config.ChinParamRadius[i][1] * beautyutils.GetDistance(keypoints[index1], keypoints[index2])
			bboxData.min_x = math.min(bboxData.min_x, keypoints[index1][1]-dr);
			bboxData.max_x = math.max(bboxData.max_x, keypoints[index1][1]+dr);
			bboxData.min_y = math.min(bboxData.min_y, keypoints[index1][2]-dr);
			bboxData.max_y = math.max(bboxData.max_y, keypoints[index1][2]+dr);
			
			index1 = beautydefined.ChinKey[i][2] + 1;
      index2 = beautydefined.ChinDir[i][1] + 1;
      dr = config.ChinParamRadius[i][1] * beautyutils.GetDistance(keypoints[index1], keypoints[index2])
			bboxData.min_x = math.min(bboxData.min_x, keypoints[index1][1]-dr);
			bboxData.max_x = math.max(bboxData.max_x, keypoints[index1][1]+dr);
			bboxData.min_y = math.min(bboxData.min_y, keypoints[index1][2]-dr);
			bboxData.max_y = math.max(bboxData.max_y, keypoints[index1][2]+dr);
    end
  end
end

function ChinScale:_Switch(on)
	-- venus editor on/off facial effect's switch
	self.on = on;
	if self.on then
		self.coef = self.coef_temp;
	else
		self.coef = 0;
	end
end

function ChinScale:_SetTempCoef(coef)
	-- venus editor temporary params value, used when switched on
	self.coef_temp = coef;
	if self.on then
		self.coef = self.coef_temp;
	end  
end

function ChinScale:_InitParams(defined)
  beautydefined = defined
  self.coef = self.coef or 0
  self.coef_temp = 1;
  -- shader params
  apolloengine.ShaderEntity.UNIFORM_CHINCOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CHINCOEF");
  apolloengine.ShaderEntity.CHINPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CHINPARA");
  apolloengine.ShaderEntity.CHINPARARADIUS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CHINPARARADIUS");
  apolloengine.ShaderEntity.CHINPOINTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CHINPOINTS");
end

function ChinScale:SetParams(config, shaderParams)
  shaderParams.chinpointArray = mathfunction.vector4array();
  shaderParams.chinParaArray = mathfunction.vector2array();
  shaderParams.chinParamRadiusArray = mathfunction.vector2array();

  LOG("part 1 iteration time: " .. #beautydefined.ChinKey - 1);
  for i = 1, #beautydefined.ChinKey - 1, 1 do
    if type(beautydefined.ChinKey[i]) == "table" then
      shaderParams.chinParaArray:PushBack(beautyutils._ArrayToVec2(config.ChinParam[i]));
--      LOG("chinParaArray: " .. " " .. #chinParaArray .. " " .. ChinParam[i][1] .. " " .. ChinParam[i][2]);
      shaderParams.chinParaArray:PushBack(beautyutils._ArrayToVec2(config.ChinParam[i]));
--      LOG("chinParaArray: " .. " " .. #chinParaArray .. " " .. ChinParam[i][1] .. " " .. ChinParam[i][2]);
      LOG("chinParaArray size: " .. i .. " " .. shaderParams.chinParaArray:Size())
    end
  end
  shaderParams.chinParaArray:PushBack(beautyutils._ArrayToVec2(config.ChinParam[#beautydefined.ChinKey]));
  LOG("ChinParam thin:  " .. shaderParams.chinParaArray:Size() .. " " .. config.ChinParam[#beautydefined.ChinKey][1] .. " " .. config.ChinParam[#beautydefined.ChinKey][2]);
  
  for i = 1, #beautydefined.ChinKey - 1, 1 do
    if type(beautydefined.ChinKey[i]) == "table" then
      shaderParams.chinParamRadiusArray:PushBack(beautyutils._ArrayToVec2(config.ChinParamRadius[i]));
      shaderParams.chinParamRadiusArray:PushBack(beautyutils._ArrayToVec2(config.ChinParamRadius[i]));
    end
  end
  shaderParams.chinParamRadiusArray:PushBack(beautyutils._ArrayToVec2(config.ChinParamRadius[#beautydefined.ChinKey]));
--  LOG("faceParaArray size: " .. faceParaArray:Size());
--  LOG("faceParamRadiusArray size: " .. faceParamRadiusArray:Size());
--  LOG("forehead: " .. AdditionFaceParam[1][1] .. " " .. AdditionFaceParam[2][1]);
  self:_InitLens(config)
end

function ChinScale:_InitLens(config)
  self.fastlens = {}
  for i = 1, #beautydefined.ChinKey - 1 do
    local index1 = beautydefined.ChinKey[i][1] + 1
    local index2 = beautydefined.ChinDir[i][2] + 1;
    local scale = beautydefined.ChinScaleScript[i]
    self.fastlens[#self.fastlens + 1] = Len(index1, index2, beautydefined.ChinParamScript[i][1] * scale, beautydefined.ChinParamScript[i][2] * scale, beautydefined.ChinParamRadiusScript[i])
    index1 = beautydefined.ChinKey[i][2]+1;
    index2 = beautydefined.ChinDir[i][1]+1;
    self.fastlens[#self.fastlens + 1] = Len(index1, index2, beautydefined.ChinParamScript[i][1] * scale, beautydefined.ChinParamScript[i][2] * scale, beautydefined.ChinParamRadiusScript[i])
  end
  local index1 = beautydefined.ChinKey[#beautydefined.ChinKey][1] + 1
  local index2 = beautydefined.ChinDir[#beautydefined.ChinKey][2] + 1;
  local scale = beautydefined.ChinScaleScript[#beautydefined.ChinKey]
  self.fastlens[#self.fastlens + 1] = Len(index1, index2, 
    beautydefined.ChinParamScript[#beautydefined.ChinKey][1] * scale, 
    beautydefined.ChinParamScript[#beautydefined.ChinKey][2] * scale, 
    beautydefined.ChinParamRadiusScript[#beautydefined.ChinKey])
end

function ChinScale:_InitQuad(quadnode, shaderParams)
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPOINTS, shaderParams.chinpointArray);
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPARA, shaderParams.chinParaArray);
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPARARADIUS, shaderParams.chinParamRadiusArray);
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHINCOEF, mathfunction.vector1(0.0));
end

function ChinScale:_DrawQuad(quadnode, keypoints, rate)
  local chinPointArray = mathfunction.vector4array();
  for i = 1, #beautydefined.ChinKey - 1 do
    if type(beautydefined.ChinKey[i])=="table" then
        local index1 = beautydefined.ChinKey[i][1]+1;
        local index2 = beautydefined.ChinDir[i][2]+1;
        chinPointArray:PushBack(beautyutils._ArrayToVec4(keypoints[index1], keypoints[index2]));
        
        index1 = beautydefined.ChinKey[i][2]+1;
        index2 = beautydefined.ChinDir[i][1]+1;
        chinPointArray:PushBack(beautyutils._ArrayToVec4(keypoints[index1], keypoints[index2]));
    end
  end
  chinPointArray:PushBack(beautyutils._ArrayToVec4(keypoints[beautydefined.ChinKey[#beautydefined.ChinKey][1]+1], keypoints[beautydefined.ChinDir[#beautydefined.ChinKey][2]+1]));
  
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHINCOEF,mathfunction.vector1(self.coef * rate));
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPOINTS,chinPointArray);
end

function ChinScale:_getWarpedKeyPointsDisplacement(keypoints, keypointsDisplacement, aspect_ratio, config, rate)
  if self.coef == 0 then
    return;
  end
  local facedir = {keypoints[75][1] - keypoints[78][1], keypoints[75][2] - keypoints[78][2]};
  facedir[2] = facedir[2] * aspect_ratio
  facedir[1] = facedir[1] / math.sqrt(facedir[1] * facedir[1] + facedir[2] * facedir[2]);
  facedir[2] = facedir[2] / math.sqrt(facedir[1] * facedir[1] + facedir[2] * facedir[2]);
  
  local coef = self.coef * rate
  local tmpDis = {}
  for i = 1, 33 do
    tmpDis[i] = {0, 0}
  end
  
  for i = 1, #self.fastlens do
    local srcIdx = self.fastlens[i]:GetSrcIdx()
    local dstIdx = self.fastlens[i]:GetDstIdx()
    local src = keypoints[srcIdx]
    local dst = keypoints[dstIdx]
    self.fastlens[i]:InitParams(src, dst, facedir, coef, aspect_ratio)
    local tmp = self.fastlens[i]:TransformWarp(src, aspect_ratio)
    tmpDis[srcIdx] = tmp
  end
  
  beautyutils.LinearInterpolation(tmpDis, 8, 26)
  for i = 1, #tmpDis do
    keypointsDisplacement[i][1] = keypointsDisplacement[i][1] + tmpDis[i][1]
    keypointsDisplacement[i][2] = keypointsDisplacement[i][2] + tmpDis[i][2]
  end
end

function ChinScale:UpdateParaValue(quadnode, config, key_index, attribute, value)
  if(attribute == "X") then
      config.ChinParam[key_index - beautydefined.chin_start + 1][1] = value;
    --      LOG("FaceParam[" .. self.key_param_table[key_index] .. "][1] set to " .. value);
    end
    if(attribute == "Y") then
      config.ChinParam[key_index - beautydefined.chin_start + 1][2] = value;
    --      LOG("FaceParam[" .. self.key_param_table[key_index] .. "][2] set to " .. value);
    end 
    if(attribute == "R") then
      config.ChinParamRadius[key_index - beautydefined.chin_start + 1][1] = value;
    --      LOG("FaceParamRadius[" .. self.key_param_table[key_index] .. "][1] set to " .. value);
      if(config.ChinParamRadius[key_index - beautydefined.chin_start + 1][1] < 0.1) then
        config.ChinParamRadius[key_index - beautydefined.chin_start + 1][1] = 0.1;
      end
    end
  local shaderParams = {}
  self:SetParams(config, shaderParams)
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPARA, shaderParams.chinParaArray);
  quadnode:SetParameter(apolloengine.ShaderEntity.CHINPARARADIUS, shaderParams.chinParamRadiusArray);
end

function ChinScale:UpdateCoeff(quadnode, value, rate)
  if(value == 1) then
    self.coef = 1.0;
  else
    self.coef = 0.0;
  end
  LOG("CHIN SCALE coef set to: " .. self.coef);
  quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHINCOEF,mathfunction.vector1(self.coef * rate));
end

function ChinScale:GetParams(config)
  LOG("ChinParam size: " .. #config.ChinParam);
  local ChinParam = beautyutils.Clone(config.ChinParam);
  local ChinParamRadius = beautyutils.Clone(config.ChinParamRadius);
  return ChinParam, ChinParamRadius
end

function ChinScale:SetCoef(coef)
  if coef == nil then
    coef = 0
  end
  
  self.coef = coef;
  --LOG("Chin Scale coef: " .. self.coef)
end

function ChinScale:Release()
  self.fastlens = {}
end
  
return ChinScale