local mathfunction = require "mathfunction"

local gmm = require "torchutility.gaussianmixturemodel"
local ViewCamera = require "torchutility.cameraviewproj"
local Robustifier = require "torchutility.robustifier"
local Substract =  require "torchutility.substract"
local Multiply =  require "torchutility.multiply"
local ToPoseList =  require "torchutility.toposelist"
local SignedSqrt =  require "torchutility.signedsqrt"
local AutoTensor =  require "torchutility.autotensor"
local Rodrigues = require "torchutility.rodrigues"
local SubTensor = require "torchutility.subtensor"
local TransformMat = require "torchutility.transformmat"
local dogleg = require "torchutility.dogleg"

local MixGauss = require "torchutility.mixgauss"
local Add =  require "torchutility.add"
local PoseExp =  require "torchutility.poseexp"
--local Rodrigues = require "torchutility.rodrigues"


require "venusdebug"
require "utility"


local offsetlist = {  
                      {-0.00087631, -0.21141872, 0.02782112  } ,
                      {0.07048489, -0.30100253, 0.01977493   } ,
                      {-0.06988833, -0.30037916, 0.02302543  } ,
                      {-0.00338452, -0.10816186, 0.00563598  } ,
                      {0.10115381, -0.6652119 , 0.01308602   } ,
                      {-0.10604072, -0.67102962, 0.01384011  } ,
                      {0.00019644, 0.01949579, 0.00392297    } ,
                      {0.08959991, -1.04856032, -0.03041559  } ,
                      {-0.09201208, -1.05466743, -0.02805149 } ,
                      {0.00222362, 0.06856801, 0.03179018    } ,
                      {0.11293758, -1.10320516, 0.08395453   } ,
                      {-0.1140553 , -1.10107698, 0.08984822  } ,
                      {0.00026099, 0.276811197e-01, -0.017975} ,
                      {0.0775219 , 0.18634844, -0.00508464   } ,
                      {-0.0748092 , 0.18417421, -0.01002048  } ,
                      {0.00377815, 0.33913339, 0.03222996    } ,
                      {0.16283901, 0.21808746, -0.01237748   } ,
                      {-0.16401207, 0.21695904, -0.01982267  } ,
                      {0.41408632, 0.20612068, -0.03989592   } ,
                      {-0.41000173, 0.20380668, -0.03998439  } ,
                      {0.65210542, 0.21512755, -0.03985218   } ,
                      {-0.65517855, 0.21242863, -0.04351591  } ,
                      {0.73177317, 0.20544502, -0.05305777   } ,
                      {-0.73557876, 0.20518065, -0.05393523  } ,
                    };
                    
local parentlist = {0,1,1,1,2,3,4,5,6,7,8,9,10,10,10,13,14,15,17,18,19,20,21,22};

local subgauss = {2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24};

local subproj = { 17, 19, 21, 18, 20, 22, 2, 5, 8, 3, 6, 9};  

local subexp = { {19,1}, {20,1}, {5,1}, {6,1} };  


local bonename = {
    "m_avg_Pelvis" ,
    "m_avg_L_Hip" ,
    "m_avg_R_Hip" ,
    "m_avg_Spine1" ,
    "m_avg_L_Knee" ,
    "m_avg_R_Knee" ,
    "m_avg_Spine2" ,
    "m_avg_L_Ankle" ,
    "m_avg_R_Ankle" ,
    "m_avg_Spine3" ,
    "m_avg_L_Foot" ,
    "m_avg_R_Foot" ,
    "m_avg_Neck" ,
    "m_avg_L_Collar" ,
    "m_avg_R_Collar" ,
    "m_avg_Head" ,
    "m_avg_L_Shoulder" ,
    "m_avg_R_Shoulder" ,
    "m_avg_L_Elbow" ,
    "m_avg_R_Elbow" ,
    "m_avg_L_Wrist" ,
    "m_avg_R_Wrist" ,
    "m_avg_L_Hand" ,
    "m_avg_R_Hand" ,
  }



local skeletonfit = {}

function skeletonfit:GetBoneName()
  return bonename;
end

function skeletonfit:GetSubProjList()
  return subproj;
end


function skeletonfit:GetLocalOffsetList()
  local ret = {};
  for i=1,#parentlist do
    local parentidx = parentlist[i];
    ret[i] = {};
    if parentidx~= 0 then
      ret[i][1] = offsetlist[i][1] - offsetlist[parentidx][1];
      ret[i][2] = offsetlist[i][2] - offsetlist[parentidx][2];
      ret[i][3] = offsetlist[i][3] - offsetlist[parentidx][3];
    else
      ret[i][1] = offsetlist[i][1];
      ret[i][2] = offsetlist[i][2];
      ret[i][3] = offsetlist[i][3];
    end
  end
  return ret;
end

function skeletonfit:Initialize()
  self.localoffset = self:GetLocalOffsetList();
  
  self.gmm = gmm();
  self.gmm:Load("docs:gmm8.vtt");
  
  self.temppose = self.gmm:MeanPose();
end


function skeletonfit:SetCamera(fx,fy,cx,cy)
    self.fx = fx;
    self.fy = fy;
    self.cx = cx;
    self.cy = cy;
end

function skeletonfit:SetStartBoneRotate(indexlist,rotatemat)
  self.svpose = {};
  
  self.svpose[1] = {0,0,0};
    
  for i=2,24 do
    local tempidx = i-2;
    self.svpose[i] = {};
    self.svpose[i][1] = self.temppose[1][tempidx*3+1];
    self.svpose[i][2] = self.temppose[1][tempidx*3+2];
    self.svpose[i][3] = self.temppose[1][tempidx*3+3];
  end
  
  for i=1,#indexlist do
    if rotatemat[i]~=nil then
      local rotvv = Rodrigues.Decompose(rotatemat[i]);
      self.svpose[indexlist[i]][1] = rotvv[1];
      self.svpose[indexlist[i]][2] = rotvv[2];
      self.svpose[indexlist[i]][3] = rotvv[3];
    end
  end
end
 

function skeletonfit:EstimateRotation(point2d,cameraoffset)

  local StartRotate = AutoTensor(self.svpose);
  local SubGauss = SubTensor(subgauss,StartRotate);
  local MixGauss = MixGauss(self.gmm,SubGauss);
  
  local SubExp = SubTensor(subexp,StartRotate);
  local ExpMul = AutoTensor({{-1,-1,-1,-1}});

  local ExpFinal = PoseExp(ExpMul,SubExp);
  
  local rotate = StartRotate;--AutoTensor(rotatelist);
  local offset = AutoTensor(self.localoffset);
  local transformmats = TransformMat(rotate,offset);
  
  local poslist = ToPoseList(transformmats,parentlist );
  
  local pointtemp = SubTensor(subproj,poslist);
  local cameraoffsetarray = {};
  for i=1,pointtemp:R():size()[1] do
    cameraoffsetarray[i] = {};
    cameraoffsetarray[i][1] = cameraoffset[1];
    cameraoffsetarray[i][2] = cameraoffset[2];
    cameraoffsetarray[i][3] = cameraoffset[3];
  end
  
  local point3doffset = AutoTensor(cameraoffsetarray);
  local point3d = pointtemp+point3doffset;    
  local projectto = AutoTensor(point2d);

  local Camera = ViewCamera(self.fx,self.fy,self.cx,self.cy,point3d);
  local Sub = Substract(projectto,Camera);
  local Robu = Robustifier(100,Sub);
  local SignedSqrt = SignedSqrt(Robu);

  _PROFILER_START();
  local weights = {4.78}
  --local weights = {7.4}
  for i=1,#weights do
    local funcs = {}
    funcs.exp = {}
    funcs.exp.fx =  function(x)
                      StartRotate:V(x);
                      local ret = 3.17*weights[i]*ExpFinal:R();
                      return ret;
                    end
                    
    funcs.exp.dx =  function(x)
                      StartRotate:V(x);
                      local ret = 3.17*weights[i]*ExpFinal:D2(StartRotate);
                      return ret;
                    end
                    
    funcs.gmm = {}
    funcs.gmm.fx =  function(x)
                      StartRotate:V(x);
                      local ret = weights[i]*MixGauss:R();
                      return ret;
                    end

    funcs.gmm.dx =  function(x)
                      StartRotate:V(x);
                      local dx = weights[i]*MixGauss:D2(StartRotate);
                      return dx;
                    end
                    
    funcs.proj = {}
    funcs.proj.fx =  function(x)
                      StartRotate:V(x);
                      local ret = SignedSqrt:R();
                      return ret;
                    end

    funcs.proj.dx =  function(x)
                      StartRotate:V(x);
                      local dx = SignedSqrt:D2(StartRotate);
                      return dx;
                    end
    local config =  {
          maxiter = 100,
          e_3 = 0.001,
        }
    dogleg(funcs, StartRotate:R(),  config); 
    LOG("stage "..i.." done,show 2d result");
    --LOG(Camera);
  end
  _PROFILER_END()
  LOG("optimize complete,let's see the result");
  LOG(Sub);
  return point3d:R(),StartRotate:R();
end




return skeletonfit;