local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'

local timerecover = b3.Class("TimeRecover", b3.Action)

function timerecover:ctor(properties)
	b3.Action.ctor(self)	
	self.name = "TimeRecover"
  self.timespeed = properties.speed;
end


function timerecover:tick(tick)
  local board = tick.blackboard;
  local timespan = board:get("timespan");
  local timemul = board:get("timemultiper");
  timemul = timemul or 1;
  timemul = timemul + self.timespeed * timespan;
  timemul = timemul < 1 and timemul or 1;
  board:set("timespan", timespan * timemul);
  board:set("timemultiper", timemul);
  return b3.SUCCESS;
end

return timerecover;