#SHADER_DEFINE ShineSeperateBlurVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE ShineSeperateBlurFragment

	FUNCTION_INPUT = 
	{
        { ATTRIBUTE_COORDNATE0,		       HIGH,	 VEC2,		      	"texture_coord"},
        { MOTION_TEXTURE,	               NONE,	 TEXTURE2D,		  	"motion_texture" },
        { RADIUS,                          HIGH,     FLOAT,             "blur_radius"},
        { UNIFORM_OFFSET,                  HIGH,     VEC2,              "uniform_offset"},
    }

#SHADER_CODE

	int radius = int(blur_radius);
	vec2 cur_pos = texture_coord - uniform_offset * float(radius);
	
	int total = radius * 2 + 1;
	float sum = 0.0;

	for (int i = 0; i < total; i++)
	{
		sum += texture2D(motion_texture, cur_pos).r;
		cur_pos += uniform_offset;
	}
	
	sum /= float(total);
    gl_FragColor = vec4(sum);
	
#END_CODE
#END_DEFINE