#SHADER_DEFINE ParallaxVS

	FUNCTION_INPUT = 
	{
		{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
		{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_Coord" },
    { UNI_VIEW_POS,            MEDIUM,    VEC3,        "in_ViewPos" },
    { CAMERA_WORLDPOSITION,			MEDIUM,		VEC3,					"in_CameraPosition"},
	}

	FUNCTION_OUTPUT = 
	{
    { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "out_Coordinate" },
    { VIEW_DIR,            MEDIUM,    VEC3,        "out_ViewDir" },
	}

#SHADER_CODE

    vec4 out_PositionWS  = in_Transfrom * in_Position;
    vec3 out_ViewDir = normalize(out_PositionWS.xyz - in_ViewPos.xyz);
	  vec4 out_Position = in_ViewPorj * out_PositionWS;
    vec2 out_Coordinate = in_Coord;
    out_Coordinate.y = 1.0- out_Coordinate.y;
    gl_Position = out_Position;
    
#END_CODE
#END_DEFINE


#SHADER_DEFINE ParallaxPS

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,			NONE,			TEXTURE2D,		"uSampler" },
    { TEXTURE_HEIGHT,			NONE,			TEXTURE2D,		"displacementMap" },
    { ATTRIBUTE_COORDNATE0,    MEDIUM,    VEC2,        "vTextureCoord" },
    { VIEW_DIR,            MEDIUM,    VEC3,        "in_ViewDir" },
	}

	FUNCTION_OUTPUT = 
	{
    
	}

#SHADER_CODE


vec4 dimensions = vec4(638.0,235.0,0.0,0.0);

float scale = 1.0;
vec2 offset = in_ViewDir.xy;
float focus = 0.3;

#define METHOD 1
#define CORRECT
#define ENLARGE 0.8
#define ANTIALIAS 11
#define AA_TRIGGER 0.8
#define AA_POWER 1.0
#define AA_MAXITER 8.0
#define MAXSTEPS 16.0
#define CONFIDENCE_MAX 2.5

#define BRANCHLOOP  
#define BRANCHSAMPLE 
#define DEBUG 0

#ifndef PERSPECTIVE
  #define PERSPECTIVE 0.000
#endif
#ifndef UPSCALE
  #define UPSCALE 1.06
#endif

#ifndef COMPRESSION
  #define COMPRESSION 0.8
#endif

const float perspective = PERSPECTIVE;
const float upscale = UPSCALE;
float steps = MAXSTEPS;

 
float maskPower = steps * 1.0;

float correctPower = 1.0;

const float compression = COMPRESSION;
const float dmin = (1.0 - compression) / 2.0;
const float dmax = (1.0 + compression) / 2.0;

const float vectorCutoff = 0.0 + dmin - 0.0001;

float aspect = dimensions.x / dimensions.y;
vec2 scale2 = vec2(scale * min(1.0, 1.0 / aspect), scale * min(1.0, aspect)) * vec2(1, -1) * vec2(ENLARGE);
mat2 baseVector = mat2(vec2((0.5 - focus) * offset - offset/2.0) * scale2, 
                       vec2((0.5 - focus) * offset + offset/2.0) * scale2);

vec2 pos = (vTextureCoord - vec2(0.5)) / vec2(upscale) + vec2(0.5);
mat2 vector = baseVector;
// perspective shift
vector[1] += (vec2(2.0) * pos - vec2(1.0)) * vec2(perspective);

float dstep = compression / (steps - 1.0);
vec2 vstep = (vector[1] - vector[0]) / vec2((steps - 1.0)) ;

vec2 posSum = vec2(0.0);


float confidenceSum = 0.0;
float minConfidence = dstep / 2.0;
  
#ifdef ANTIALIAS
  #ifndef AA_TRIGGER
    #define AA_TRIGGER 0.8
  #endif
  #if ANTIALIAS == 11 || ANTIALIAS == 12
    #ifndef AA_POWER
      #define AA_POWER 0.5
    #endif
    #ifndef AA_MAXITER
      #define AA_MAXITER 16.0
    #endif
    float loopStep = 1.0;
  #endif
  
  #define LOOP_INDEX j
  float j = 0.0;
#endif

#ifndef LOOP_INDEX
  #define LOOP_INDEX i
#endif


for(float i = 0.0; i < MAXSTEPS; ++i) {
  vec2 vpos = pos + vector[1] - LOOP_INDEX * vstep;
  float dpos = 0.5 + compression / 2.0 - LOOP_INDEX * dstep;
  #ifdef BRANCHLOOP
  if (dpos >= vectorCutoff && confidenceSum < CONFIDENCE_MAX) {
  #endif
    float depth = 1.0 - texture2D(displacementMap, vpos ).r;
    depth = clamp(depth, dmin, dmax);
    float confidence;
    
    confidence = step(dpos, depth + 0.001);

    #ifndef BRANCHLOOP
     confidence *= step(vectorCutoff, dpos);
     confidence *= step(confidenceSum, CONFIDENCE_MAX);
    #endif
      
    #ifndef ANTIALIAS
    #elif ANTIALIAS == 1 // go back halfstep, go forward fullstep - branched
      if (confidence > AA_TRIGGER && i == j) {
        j -= 0.5;
      } else {
        j += 1.0;
      }

    #elif ANTIALIAS == 2 // go back halfstep, go forward fullstep - mult
      j += 1.0 + step(AA_TRIGGER, confidence) 
           * step(i, j) * -1.5; 

    #elif ANTIALIAS == 11
      if (confidence >= AA_TRIGGER && i == j && steps - i > 1.0) {
        loopStep = AA_POWER * 2.0 / min(AA_MAXITER, steps - i - 1.0);
        j -= AA_POWER + loopStep;
      }
      confidence *= loopStep;
      j += loopStep;
    #elif ANTIALIAS == 12
      float _if_aa = step(AA_TRIGGER, confidence)
                   * step(i, j)
                   * step(1.5, steps - i);
      loopStep = _if_aa * (AA_POWER * 2.0 / min(AA_MAXITER, max(0.1, steps - i - 1.0)) - 1.0) + 1.0;
      confidence *= loopStep;
      j += _if_aa * -(AA_POWER + loopStep) + loopStep;
    #endif

    #ifdef BRANCHSAMPLE
    if (confidence > 0.0) {
    #endif
      #define CORRECTION_MATH +( ( vec2((depth - dpos) / (dstep * correctPower)) * vstep ))
      posSum += (vpos CORRECTION_MATH) * confidence;    
      confidenceSum += confidence;
        
    #ifdef BRANCHSAMPLE
    }
    #endif

  #ifdef BRANCHLOOP
  }
  #endif
};


gl_FragColor = texture2D(uSampler, posSum / confidenceSum);

 
#END_CODE
#END_DEFINE



