//@author      : Zhu Fei
//@date        : 2019-06-26
//@description : shader to draw point sprite for bling effect
//@version     : 1.0
//@author      : Zhu Fei
//@date        : 2020-03-03
//@description : bling v2 features
//@version     : 2.0

#include "comm:documents/material/shaders/functions/blendmode.function"

#SHADER_DEFINE BlingBillboardVertex

    FUNCTION_INPUT =
    {
        {ATTRIBUTE_POSITION,   HIGH, VEC2, "in_pos"},             //position of billboard vertex
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "in_tex_coord"},       //texture coordinate of billboard vertex
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "in_frame_tex_coord"}, //texture coordinate of billboard center on background frame
        {ATTRIBUTE_COORDNATE2, HIGH, VEC2, "in_tex_idx"}          //index of texture to use for this billboard
    }
    FUNCTION_OUTPUT =
    {
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "out_tex_coord"},
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "out_frame_tex_coord"},
        {ATTRIBUTE_COORDNATE2, HIGH, VEC2, "out_tex_idx"}
    }

#SHADER_CODE
    gl_Position              = vec4(in_pos, 0.0, 1.0);
    vec2 out_tex_coord       = in_tex_coord;
    vec2 out_frame_tex_coord = in_frame_tex_coord;
    vec2 out_tex_idx         = in_tex_idx;
#END_CODE

#END_DEFINE

#SHADER_DEFINE BlingBillboardFragment

    FUNCTION_INPUT =
    {
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "in_tex_coord"},
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "in_frame_tex_coord"},
        {ATTRIBUTE_COORDNATE2, HIGH, VEC2, "in_tex_idx"},
        {POINT_TEXTURE,         NONE, TEXTURE2D, "in_pt_texture"},
        {SECOND_POINT_TEXTURE,  NONE, TEXTURE2D, "in_second_pt_texture"},
        {FRAME_TEXTURE,         NONE, TEXTURE2D, "in_frame_texture"},
        {BLEND_MODE,            HIGH, FLOAT,     "in_blend_mode"}
    }

#SHADER_CODE
    vec4 base_color      = texture2D(in_frame_texture, in_frame_tex_coord);
    vec4 billboard_color;
    if(in_tex_idx.x > 0.0) //x component of in_tex_idx stores index of billboard texture
        billboard_color = texture2D(in_second_pt_texture, in_tex_coord);
    else
        billboard_color = texture2D(in_pt_texture, in_tex_coord);
    int blend_mode = int(in_blend_mode);
    gl_FragColor        = vec4(blend(blend_mode, base_color.rgb, billboard_color.rgb), billboard_color.a);
#END_CODE

#END_DEFINE