local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local GetParametersCommand = CommandBase:extend("GetParametersCommand");

function GetParametersCommand:new(comuid, smsid)
    GetParametersCommand.super.new(self);
    self._comUid = comuid;
    self._smsid = smsid;
    self._parameters = nil;
end

function GetParametersCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        local sms = ani.StateMachines;
        self._parameters = sms[self._smsid].Parameters;
    end
    self:EndCmd();
end

function GetParametersCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return GetParametersCommand;