local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteParameterCommand = CommandBase:extend("DeleteParameterCommand");

function DeleteParameterCommand:new(uuid, smsId, paramId, transitionId)
    DeleteParameterCommand.super.new(self);
    self._uuid = uuid;
    self._deleteId = paramId;
    self._transitionId = transitionId;
    self._smsId = smsId;
end

function DeleteParameterCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._deleteId ~= nil then
        ani:RemoveParameter(self._smsId, self._deleteId, self._transitionId ~= nil and self._transitionId or "");
      end
    end
    self:EndCmd();
end

function DeleteParameterCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return DeleteParameterCommand;